/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.PropertyValidationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyNameValidationVisitor
extends EObjectValidationVisitor {
    private final EStructuralFeature _parentClassNameFeature;
    private final Map<IType, Map<String, JDTBeanProperty>> _propertyCache;
    private final Map<String, IType> _typeCache;

    public PropertyNameValidationVisitor(EStructuralFeature feature, EStructuralFeature parentClassNameFeature, String version) {
        super(feature, version);
        this._parentClassNameFeature = parentClassNameFeature;
        this._propertyCache = new HashMap<IType, Map<String, JDTBeanProperty>>();
        this._typeCache = new HashMap<String, IType>();
    }

    @Override
    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return PropertyValidationVisitor.NO_CHILDREN;
    }

    @Override
    protected void doValidate(EObject object, List messages, IFile file) {
        String parentClassType = this.getParentClassType(object);
        if (parentClassType != null) {
            boolean isBeanProperty = this.validateProperty((PropertyNameType)object, file.getProject(), parentClassType);
            String propertyName = ((PropertyNameType)object).getTextContent();
            if (!isBeanProperty) {
                PropertyValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_BEAN_PROPERTY_NOT_FOUND(propertyName, parentClassType), object, file);
            }
        }
    }

    private String getParentClassType(EObject object) {
        EStructuralFeature feature;
        EObject parentClassTypeObject;
        EObject owningObject;
        String parentClassType = null;
        EObject property = object.eContainer();
        if (property != null && (owningObject = property.eContainer()) != null && (parentClassTypeObject = (EObject)owningObject.eGet(this._parentClassNameFeature)) != null && (feature = parentClassTypeObject.eClass().getEStructuralFeature("textContent")) != null) {
            parentClassType = (String)parentClassTypeObject.eGet(feature);
        }
        return parentClassType;
    }

    private boolean validateProperty(PropertyNameType object, IProject project, String parentClassType) {
        boolean isBeanProperty = false;
        IType type = this.getType(parentClassType, project);
        if (type != null) {
            JDTBeanProperty beanProperty;
            String propertyName = object.getTextContent();
            Map<String, JDTBeanProperty> cachedType = this._propertyCache.get(type);
            if (cachedType == null) {
                cachedType = this.getProperties(type, project);
                this._propertyCache.put(type, cachedType);
            }
            if ((beanProperty = cachedType.get(propertyName)) != null) {
                isBeanProperty = true;
            }
        }
        return isBeanProperty;
    }

    private Map<String, JDTBeanProperty> getProperties(IType type, IProject project) {
        JDTBeanIntrospector introspector = new JDTBeanIntrospector(type);
        return introspector.getProperties();
    }

    private IType getType(String typeName, IProject project) {
        IType type = this._typeCache.get(typeName);
        if (type == null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                type = javaProject.findType(typeName);
                this._typeCache.put(typeName, type);
            }
            catch (JavaModelException e) {
                JSFCorePlugin.log(new Exception(e), "Problem validating on parent: " + typeName);
            }
        }
        return type;
    }
}

