/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadProxyServer;
import org.jboss.tools.livereload.core.internal.server.wst.LiveReloadServerBehaviour;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.TimeoutUtils;

public class WSTUtils {
    public static final String LIVERELOAD_RUNTIME_TYPE = "org.jboss.tools.livereload.serverTypeRuntime";
    public static final String LIVERELOAD_SERVER_TYPE = "org.jboss.tools.livereload.serverType";
    public static final String OPENSHIFT_SERVER_TYPE = "org.jboss.tools.openshift.express.openshift.server.type";
    public static final String HTTP_PREVIEW_SERVER_TYPE = "org.eclipse.wst.server.preview.server";
    public static final String HTTP_PREVIEW_PORT = "port";
    public static final String TEST_PREVIEW_SERVER_TYPE = "org.jboss.tools.livereload.test.previewServerType";
    public static final String TEST_PREVIEW_PORT = "port";
    public static final String JBOSSASAS_SERVER_PREFIX = "org.jboss.ide.eclipse.as.";
    public static final String JBOSSAS_SERVER_PORT = "org.jboss.ide.as.serverport";
    public static final String TOMCAT_60_SERVER_TYPE = "org.eclipse.jst.server.tomcat.60";
    public static final String TOMCAT_70_SERVER_TYPE = "org.eclipse.jst.server.tomcat.70";

    public static List<IServer> findLiveReloadServers() {
        ArrayList<IServer> liveReloadServers = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (WSTUtils.isLiveReloadServer(server)) {
                liveReloadServers.add(server);
            }
            ++n2;
        }
        return liveReloadServers;
    }

    public static IServer findLiveReloadServer() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (WSTUtils.isLiveReloadServer(server)) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    public static ServerBehaviourDelegate findServerBehaviour(String serverId) {
        IServer server = ServerCore.findServer((String)serverId);
        if (server != null) {
            return (ServerBehaviourDelegate)server.loadAdapter(ServerBehaviourDelegate.class, null);
        }
        return null;
    }

    public static ServerBehaviourDelegate findServerBehaviour(IServer server) {
        if (server != null) {
            return (ServerBehaviourDelegate)server.loadAdapter(ServerBehaviourDelegate.class, null);
        }
        return null;
    }

    public static IServer extractServer(String browserLocation) {
        return WSTUtils.extractServer(browserLocation, Arrays.asList(ServerCore.getServers()));
    }

    public static IServer extractServer(String browserLocation, List<IServer> servers) {
        try {
            URL url = new URL(browserLocation);
            int port = url.getPort();
            for (IServer server : servers) {
                if (port == WSTUtils.getWebPort(server)) {
                    return server;
                }
                if (!WSTUtils.isLiveReloadServer(server)) continue;
                Map proxyPorts = server.getAttribute("proxy_ports", Collections.emptyMap());
                for (Map.Entry entry : proxyPorts.entrySet()) {
                    Integer serverProxiedPort = (Integer)entry.getValue();
                    if (port != serverProxiedPort) continue;
                    String serverId = (String)entry.getKey();
                    return ServerCore.findServer((String)serverId);
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.error("Unable to parse URL '" + browserLocation + "'", e);
        }
        Logger.debug("Could not identify server from client location " + browserLocation);
        return null;
    }

    public static int getWebPort(IServer server) {
        if (server.getServerState() != 2 || server.getServerType() == null) {
            return -1;
        }
        String serverType = server.getServerType().getId();
        Object adapter = server.loadAdapter(IJBossServer.class, null);
        if (adapter != null && adapter instanceof IJBossServer) {
            return ((IJBossServer)adapter).getJBossWebPort();
        }
        if (serverType.equals(HTTP_PREVIEW_SERVER_TYPE)) {
            return server.getAttribute("port", 8080);
        }
        if (serverType.equals(TEST_PREVIEW_SERVER_TYPE)) {
            return server.getAttribute("port", 8080);
        }
        if (serverType.equals(LIVERELOAD_SERVER_TYPE)) {
            return server.getAttribute("org.jboss.tools.livereload.core.websocket_port", -1);
        }
        if (TOMCAT_70_SERVER_TYPE.equals(serverType) || TOMCAT_60_SERVER_TYPE.equals(serverType)) {
            TomcatServerBehaviour tomcatServer = (TomcatServerBehaviour)server.getAdapter(ServerBehaviourDelegate.class);
            ServerPort[] serverPortArray = tomcatServer.getTomcatServer().getServerPorts();
            int n = serverPortArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPort port = serverPortArray[n2];
                if ("HTTP".equals(port.getProtocol())) {
                    return port.getPort();
                }
                ++n2;
            }
        }
        Logger.debug("Assuming that server '" + server.getName() + "' is running on port 8080. LiveReload may not work as expected if it is not the case.");
        return 8080;
    }

    public static boolean isLiveReloadServer(IServer server) {
        return server != null && server.getServerType() != null && LIVERELOAD_SERVER_TYPE.equals(server.getServerType().getId());
    }

    public static List<IServer> filterStartedServers(List<IServer> servers) {
        ArrayList<IServer> startedServers = new ArrayList<IServer>();
        for (IServer server : servers) {
            if (server.getServerState() != 2) continue;
            startedServers.add(server);
        }
        return startedServers;
    }

    public static IServer createLiveReloadServer(int websocketPort, boolean injectScript, boolean allowRemoteConnections) throws CoreException {
        return WSTUtils.createLiveReloadServer("LiveReload Server at localhost", "localhost", websocketPort, injectScript, allowRemoteConnections);
    }

    public static IServer createLiveReloadServer(String serverName, String hostname, int websocketPort, boolean injectScript, boolean allowRemoteConnections) throws CoreException {
        IRuntimeType rt = ServerCore.findRuntimeType((String)LIVERELOAD_RUNTIME_TYPE);
        IRuntimeWorkingCopy rwc = rt.createRuntime(null, null);
        IRuntime runtime = rwc.save(true, null);
        IServerType st = ServerCore.findServerType((String)LIVERELOAD_SERVER_TYPE);
        IServerWorkingCopy swc = st.createServer(serverName, null, null);
        swc.setServerConfiguration(null);
        swc.setName(serverName);
        swc.setHost(hostname);
        swc.setRuntime(runtime);
        swc.setAttribute("org.jboss.tools.livereload.core.websocket_port", websocketPort);
        swc.setAttribute("org.jboss.tools.livereload.core.enable_proxy_server", true);
        swc.setAttribute("org.jboss.tools.livereload.core.enable_script_injection", injectScript);
        swc.setAttribute("org.jboss.tools.livereload.core.allow_remote_connections", allowRemoteConnections);
        return swc.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static LiveReloadProxyServer findLiveReloadProxyServer(IServer appServer) {
        for (IServer liveReloadServer : WSTUtils.findLiveReloadServers()) {
            LiveReloadServerBehaviour serverBehaviour;
            if (!WSTUtils.isServerStarted(liveReloadServer) || (serverBehaviour = (LiveReloadServerBehaviour)liveReloadServer.getAdapter(ServerBehaviourDelegate.class)) == null || !serverBehaviour.getProxyServers().containsKey(appServer)) continue;
            return serverBehaviour.getProxyServers().get(appServer);
        }
        return null;
    }

    public static boolean isServerStarted(IServer appServer) {
        return appServer.getServerState() == 2;
    }

    public static Job startOrRestartServer(final IServer server, final int timeout, final TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        if (server == null) {
            return null;
        }
        final boolean isStopping = server.getServerState() == 3;
        final boolean needsStop = server.getServerState() == 1 || server.getServerState() == 2;
        final boolean needsRestart = isStopping || needsStop;
        String jobMessage = String.valueOf(needsRestart ? "Restarting " : "Starting ") + server.getName() + "...";
        return new Job(jobMessage){

            protected IStatus run(IProgressMonitor monitor) {
                ServerListener listener = new ServerListener(server);
                try {
                    Long limitTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, unit);
                    if (needsStop) {
                        server.stop(true);
                    }
                    if (needsStop || isStopping) {
                        while (!listener.serverStopped && System.currentTimeMillis() < limitTime && !monitor.isCanceled()) {
                            TimeUnit.MILLISECONDS.sleep(500L);
                        }
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    listener.reset();
                    int ticks = (int)TimeUnit.SECONDS.convert(timeout, unit);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, ticks);
                    server.start("run", (IProgressMonitor)subMonitor);
                    while (!(listener.serverStarted || listener.serverStarting && listener.serverStopped || System.currentTimeMillis() >= limitTime || monitor.isCanceled())) {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    subMonitor.done();
                    if (server.getServerState() != 2) {
                        if (needsRestart) {
                            String errorMessage = "Failed to restart " + server.getName() + " before timeout";
                            Logger.error(errorMessage);
                        } else {
                            String errorMessage = "Failed to start " + server.getName() + " before timeout";
                            Logger.error(errorMessage);
                        }
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception exception) {
                    String errorMessage;
                    if (needsRestart) {
                        errorMessage = "Failed to restart " + server.getName() + " before timeout";
                        Logger.error(errorMessage);
                    } else {
                        errorMessage = "Failed to start " + server.getName() + " before timeout";
                        Logger.error(errorMessage);
                    }
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    listener.dispose();
                }
            }
        };
    }

    public static void stop(IServer server, long duration, TimeUnit unit) throws TimeoutException {
        if (server.canStop().isOK()) {
            final ServerListener listener = new ServerListener(server);
            try {
                server.stop(true);
                TimeoutUtils.timeout(new TimeoutUtils.TaskMonitor(){

                    @Override
                    public boolean isComplete() {
                        return listener.serverStopped;
                    }
                }, duration, unit);
            }
            finally {
                listener.dispose();
            }
        }
    }

    public static void restart(IServer server, long duration, TimeUnit unit) {
        final ServerListener listener = new ServerListener(server);
        try {
            server.restart("run", (IProgressMonitor)new NullProgressMonitor());
            TimeoutUtils.timeout(new TimeoutUtils.TaskMonitor(){

                @Override
                public boolean isComplete() {
                    return listener.serverStopped && listener.serverStarted;
                }
            }, duration, unit);
        }
        finally {
            listener.dispose();
        }
    }

    static class ServerListener
    implements IServerListener {
        private final IServer server;
        public boolean serverStopped = false;
        public boolean serverStarted = false;
        public boolean serverStarting = false;
        public boolean serverStopping = false;

        public ServerListener(IServer server) {
            this.server = server;
            server.addServerListener((IServerListener)this);
        }

        public void dispose() {
            this.server.removeServerListener((IServerListener)this);
        }

        public void serverChanged(ServerEvent event) {
            if (event.getServer().getServerState() == 4) {
                Logger.debug("Server stopped");
                this.serverStopped = true;
            } else if (event.getServer().getServerState() == 3) {
                Logger.debug("Server stopping");
                this.serverStopping = true;
            } else if (event.getServer().getServerState() == 1) {
                Logger.debug("Server starting");
                this.serverStarting = true;
            } else if (event.getServer().getServerState() == 2) {
                Logger.debug("Server started");
                this.serverStarted = true;
            }
        }

        public void reset() {
            this.serverStopped = false;
            this.serverStarted = false;
            this.serverStarting = false;
            this.serverStopping = false;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerListener other = (ServerListener)obj;
            return !(this.server == null ? other.server != null : !this.server.getName().equals(other.server));
        }
    }
}

