/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.TimeoutException;

public class TimeoutUtils {
    public static boolean timeout(final TaskMonitor monitor, final long duration, final TimeUnit unit) throws TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                Long limitTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(duration, unit);
                while (!monitor.isComplete() && System.currentTimeMillis() < limitTime) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        try {
            future.get(duration, unit);
            return false;
        }
        catch (Exception e) {
            Logger.error("Operation failed to complete within expected time", e);
            return true;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static abstract class TaskMonitor {
        public abstract boolean isComplete();
    }
}

