/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientDisconnectedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerResourcePublishedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerResourcePublishedFilter;
import org.jboss.tools.livereload.core.internal.service.Subscriber;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEvent;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEventFallbackFilter;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEventFilter;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ProjectUtils;
import org.jboss.tools.livereload.core.internal.util.ReloadCommandGenerator;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;

@WebSocket
public class LiveReloadWebSocket
implements Subscriber {
    private static final String helloServerToClientHandShakeMessage = "{\"command\":\"hello\",\"protocols\":[\"http://livereload.com/protocols/official-7\"]}";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static EventService eventService = EventService.getInstance();
    private final String clientId;
    private final String clientAddress;
    private Session session;
    private String browserLocation = null;
    private boolean fallbackMode = false;
    private final UUID id = UUID.randomUUID();

    public LiveReloadWebSocket(String clientAddress) {
        this.clientId = clientAddress != null ? clientAddress : "unknown IP Address";
        this.clientAddress = clientAddress;
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        Logger.debug("Opening websocket session {} -> {}", this.id, this.getId());
        this.session = session;
    }

    @OnWebSocketClose
    public void onClose(int closeCode, String closeReason) {
        Logger.debug("LiveReload client connection closed (" + this.id + ") with code " + closeCode + " and reason " + closeReason);
        eventService.unsubscribe(this);
        if (this.session != null) {
            eventService.publish(new LiveReloadClientDisconnectedEvent(this.session));
        }
    }

    public void sendMessage(String text) throws IOException {
        if (!this.session.isOpen()) {
            Logger.debug("Removing pending closed connection {}", this.getId());
            eventService.unsubscribe(this);
            return;
        }
        Logger.debug("Sending message from websocket#{}: '{}'", this.id, text);
        this.session.getRemote().sendString(text);
    }

    @OnWebSocketMessage
    public void onMessage(String text) {
        Logger.debug("Received message on socket #{}: '{}'", this.id, text);
        try {
            JsonNode rootNode = mapper.readTree(text.replace("\\", "\\\\"));
            String commandValue = rootNode.path("command").asText();
            if ("hello".equals(commandValue)) {
                this.sendMessage(helloServerToClientHandShakeMessage);
            } else if ("info".equals(commandValue) || "url".equals(commandValue)) {
                this.browserLocation = rootNode.path("url").asText();
                this.fallbackMode = false;
                if (this.browserLocation == null) {
                    return;
                }
                if (this.browserLocation.startsWith("file://")) {
                    IProject project = ProjectUtils.extractProject(this.browserLocation);
                    eventService.subscribe(this, new WorkspaceResourceChangedEventFilter(project));
                    eventService.publish(new LiveReloadClientConnectedEvent(project));
                } else if (this.browserLocation.startsWith("http://")) {
                    IServer server = WSTUtils.extractServer(this.browserLocation);
                    if (server != null && WSTUtils.isLiveReloadServer(server)) {
                        IProject project = ProjectUtils.findProjectFromResourceLocation((IPath)new Path(new URL(this.browserLocation).getFile()));
                        eventService.subscribe(this, new WorkspaceResourceChangedEventFilter(project));
                        eventService.publish(new LiveReloadClientConnectedEvent(project));
                    } else if (server != null) {
                        eventService.subscribe(this, new ServerResourcePublishedFilter(server));
                        eventService.publish(new LiveReloadClientConnectedEvent(server));
                    } else {
                        this.fallbackMode = true;
                        eventService.subscribe(this, new WorkspaceResourceChangedEventFallbackFilter());
                        eventService.publish(new LiveReloadClientConnectedEvent(this.browserLocation));
                        Logger.info("Falling back to file changes notification for browser location: " + this.browserLocation);
                    }
                } else {
                    Logger.error("Cloding session because client command is unsupported: " + commandValue);
                    this.session.close();
                }
            }
        }
        catch (IOException e) {
            Logger.error("Failed to reply to LivreReload client hand-shake", e);
        }
    }

    @Override
    public void inform(EventObject e) {
        try {
            if (e instanceof WorkspaceResourceChangedEvent) {
                if (this.fallbackMode) {
                    String command = ReloadCommandGenerator.generateReloadCommand(this.browserLocation);
                    this.sendMessage(command);
                } else {
                    WorkspaceResourceChangedEvent event = (WorkspaceResourceChangedEvent)e;
                    List<String> commands = ReloadCommandGenerator.generateReloadCommands(event.getChangedResources());
                    for (String command : commands) {
                        this.sendMessage(command);
                    }
                }
            } else if (e instanceof ServerResourcePublishedEvent) {
                String command = ReloadCommandGenerator.generateReloadCommand(this.browserLocation);
                this.sendMessage(command);
            } else {
                Logger.debug("Ignoring event " + e);
            }
        }
        catch (URISyntaxException ex) {
            Logger.error("Failed to generate reload command to send to browser", ex);
        }
        catch (IOException ex) {
            Logger.error("Failed to send reload command to browser from socket #" + this.id, ex);
        }
    }

    public void destroy() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
        eventService.unsubscribe(this);
    }

    @Override
    public String getId() {
        return String.valueOf(this.clientId) + " at " + this.browserLocation;
    }
}

