/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.util.EventObject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadScriptFileServlet;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadScriptInjectionFilter;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadWebSocketServlet;
import org.jboss.tools.livereload.core.internal.server.jetty.WorkspaceFileServlet;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectionFilter;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientDisconnectedEvent;
import org.jboss.tools.livereload.core.internal.service.Subscriber;

public class LiveReloadServer
extends Server
implements Subscriber {
    private static final String MIN_WEB_SOCKET_PROTOCOL_VERSION = "minVersion";
    private static final String MIN_WEB_SOCKET_PROTOCOL_VERSION_VALUE = "-1";
    private ServerConnector websocketConnector;
    private final int websocketPort;
    private final String hostname;
    private int connectedClients = 0;

    public LiveReloadServer(String name, String hostname, int websocketPort, boolean enableProxyServer, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.websocketPort = websocketPort;
        this.hostname = hostname;
        this.configure(name, hostname, websocketPort, enableProxyServer, allowRemoteConnections, enableScriptInjection);
    }

    private void configure(String name, String hostname, int websocketPort, boolean enableProxyServer, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.setAttribute("serverName", name);
        this.websocketConnector = new ServerConnector((Server)this);
        this.websocketConnector.setReuseAddress(false);
        if (!allowRemoteConnections) {
            this.websocketConnector.setHost(hostname);
        }
        this.websocketConnector.setPort(websocketPort);
        this.addConnector((Connector)this.websocketConnector);
        ServletContextHandler context = new ServletContextHandler(1);
        ServletHolder liveReloadServletHolder = new ServletHolder("ws-events", (Servlet)new LiveReloadWebSocketServlet());
        liveReloadServletHolder.setInitParameter(MIN_WEB_SOCKET_PROTOCOL_VERSION, MIN_WEB_SOCKET_PROTOCOL_VERSION_VALUE);
        context.addServlet(liveReloadServletHolder, "/livereload");
        context.addServlet(new ServletHolder((Servlet)new LiveReloadScriptFileServlet()), "/livereload.js");
        if (enableProxyServer) {
            context.addServlet(new ServletHolder((Servlet)new WorkspaceFileServlet()), "/*");
            if (enableScriptInjection) {
                context.addFilter(new FilterHolder((Filter)new LiveReloadScriptInjectionFilter(websocketPort)), "/*", null);
            }
        }
        this.setHandler((Handler)context);
        EventService.getInstance().subscribe(this, new LiveReloadClientConnectionFilter());
    }

    public int getNumberOfConnectedClients() {
        return this.connectedClients;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.websocketPort;
    }

    public String toString() {
        return "LiveReload Server";
    }

    @Override
    public void inform(EventObject event) {
        if (event instanceof LiveReloadClientConnectedEvent) {
            ++this.connectedClients;
        } else if (event instanceof LiveReloadClientDisconnectedEvent) {
            --this.connectedClients;
            if (this.connectedClients < 0) {
                this.connectedClients = 0;
            }
        }
    }

    @Override
    public String getId() {
        return this.toString();
    }
}

