/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.tools.livereload.core.internal.server.jetty.ApplicationsProxyServlet;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadScriptInjectionFilter;

public class LiveReloadProxyServer
extends Server {
    private ServerConnector connector;
    private final String proxyHost;
    private final String targetHost;
    private final int proxyPort;
    private final int targetPort;

    public LiveReloadProxyServer(String proxyHost, int proxyPort, String targetHost, int targetPort, int liveReloadPort, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.configure(proxyHost, proxyPort, targetHost, targetPort, liveReloadPort, allowRemoteConnections, enableScriptInjection);
    }

    private void configure(String proxyHost, int proxyPort, String targetHost, int targetPort, int liveReloadPort, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.setAttribute("serverName", "LiveReload-Proxy-Server-" + proxyPort + ":" + targetPort);
        ServerConnector connector = new ServerConnector((Server)this);
        if (!allowRemoteConnections) {
            connector.setHost(proxyHost);
        } else {
            connector.setHost(null);
        }
        connector.setPort(proxyPort);
        this.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder proxyServletHolder = new ServletHolder((Servlet)new ApplicationsProxyServlet(proxyHost, proxyPort, targetHost, targetPort));
        proxyServletHolder.setInitParameter("maxThreads", "256");
        context.addServlet(proxyServletHolder, "/*");
        this.setHandler((Handler)context);
        if (enableScriptInjection) {
            context.addFilter(new FilterHolder((Filter)new LiveReloadScriptInjectionFilter(liveReloadPort)), "/*", null);
        }
    }

    public int getNumberOfConnectedClients() {
        return this.connector.getConnectedEndPoints().size();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public String toString() {
        return "Proxy Server (" + this.proxyPort + " -> " + this.targetPort + ")";
    }
}

