/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.osgi.framework.BundleContext;

public class JBossLiveReloadCoreActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.livereload.core";
    private static JBossLiveReloadCoreActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        for (IServer liveReloadServer : WSTUtils.findLiveReloadServers()) {
            try {
                WSTUtils.stop(liveReloadServer, 10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                Logger.error("Failed to stop '" + liveReloadServer.getName() + "' within expected duration.", e);
            }
            catch (RuntimeException e) {
                Logger.error("Failed to stop '" + liveReloadServer.getName() + "'", e);
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static JBossLiveReloadCoreActivator getDefault() {
        return plugin;
    }

    public InputStream getResourceContent(String path) throws IOException {
        URL resource = this.getBundle().getResource(path);
        if (resource == null) {
            return null;
        }
        return resource.openStream();
    }
}

