/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.repositories;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.maven.ui.internal.repositories.AbstractRepositoryIdentifier;
import org.jboss.tools.maven.ui.internal.repositories.ILocalRepositoryIdentifier;
import org.jboss.tools.maven.ui.internal.repositories.MarkedRepoIdentifier;
import org.jboss.tools.maven.ui.internal.repositories.SettingsRepositoryBuilder;
import org.jboss.tools.maven.ui.wizard.RepositoryWrapper;

public class RepositoryIdentificationManager {
    List<ILocalRepositoryIdentifier> identifiers = new ArrayList<ILocalRepositoryIdentifier>(3);

    public RepositoryIdentificationManager() {
        this.identifiers.add(new MarkedRepoIdentifier());
        this.identifiers.add(new EAPRepoIdentifier());
        this.identifiers.add(new WFKRepoIdentifier());
    }

    public RepositoryWrapper identifyRepository(File directory, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        for (ILocalRepositoryIdentifier identifier : this.identifiers) {
            if (monitor.isCanceled()) {
                return null;
            }
            RepositoryWrapper repo = identifier.identifyRepository(directory, monitor);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    static class EAPRepoIdentifier
    extends AbstractRepositoryIdentifier {
        static final String JBOSS_EAP_MAVEN_REPOSITORY = "JBoss EAP Maven Repository";
        static final String JBOSS_EAP_MAVEN_REPOSITORY_ID = "jboss-eap-maven-repository";
        private static final String JSF_IMPL = "com" + File.separator + "sun" + File.separator + "faces" + File.separator + "jsf-impl";

        EAPRepoIdentifier() {
        }

        @Override
        protected boolean matches(File rootDirectory) {
            File jsfDir = new File(rootDirectory, JSF_IMPL);
            if (jsfDir.isDirectory()) {
                final boolean[] found = new boolean[1];
                jsfDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname != null && pathname.getName() != null && pathname.getName().contains("redhat")) {
                            found[0] = true;
                            return true;
                        }
                        return false;
                    }
                });
                return found[0];
            }
            return false;
        }

        @Override
        protected RepositoryWrapper getRepository(File rootDirectory) {
            String url = this.getUrl(rootDirectory);
            if (url == null) {
                return null;
            }
            SettingsRepositoryBuilder builder = new SettingsRepositoryBuilder().setId(JBOSS_EAP_MAVEN_REPOSITORY_ID).setName(JBOSS_EAP_MAVEN_REPOSITORY).setUrl(url);
            return new RepositoryWrapper(builder.get());
        }
    }

    static class WFKRepoIdentifier
    extends AbstractRepositoryIdentifier {
        static final String JBOSS_WFK_MAVEN_REPOSITORY = "JBoss WFK Maven Repository";
        static final String JBOSS_WFK_MAVEN_REPOSITORY_ID = "jboss-wfk-maven-repository";
        private static final String WFK_BOMS = "com" + File.separator + "redhat" + File.separator + "jboss" + File.separator + "wfk" + File.separator + "boms";

        WFKRepoIdentifier() {
        }

        @Override
        protected boolean matches(File rootDirectory) {
            return new File(rootDirectory, WFK_BOMS).isDirectory();
        }

        @Override
        protected RepositoryWrapper getRepository(File rootDirectory) {
            String url = this.getUrl(rootDirectory);
            if (url == null) {
                return null;
            }
            SettingsRepositoryBuilder builder = new SettingsRepositoryBuilder().setId(JBOSS_WFK_MAVEN_REPOSITORY_ID).setName(JBOSS_WFK_MAVEN_REPOSITORY).setUrl(url);
            return new RepositoryWrapper(builder.get());
        }
    }
}

