/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.repositories;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.maven.ui.internal.repositories.AbstractRepositoryIdentifier;
import org.jboss.tools.maven.ui.internal.repositories.SettingsRepositoryBuilder;
import org.jboss.tools.maven.ui.wizard.RepositoryWrapper;

class MarkedRepoIdentifier
extends AbstractRepositoryIdentifier {
    MarkedRepoIdentifier() {
    }

    @Override
    protected boolean matches(File rootDirectory) {
        File marker = this.getMarker(rootDirectory);
        return marker.isFile() && marker.canRead();
    }

    private File getMarker(File directory) {
        File marker = new File(directory, ".maven-repository");
        return marker;
    }

    private Properties loadProperties(File marker) {
        Properties props;
        block5: {
            props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(marker);
                    props.load(fis);
                }
                catch (IOException e) {
                    Activator.log("Can't load properties from " + marker + " : " + e.getLocalizedMessage());
                    props = null;
                    IOUtils.closeQuietly((InputStream)fis);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        return props;
    }

    @Override
    protected RepositoryWrapper getRepository(File rootDirectory) {
        String url = this.getUrl(rootDirectory);
        if (url == null) {
            return null;
        }
        Properties props = this.loadProperties(this.getMarker(rootDirectory));
        if (props == null) {
            return null;
        }
        String name = props.getProperty("name");
        String id = props.getProperty("repository-id");
        String profileId = props.getProperty("profile-id");
        if (id == null || id.trim().isEmpty()) {
            if (name == null || name.trim().isEmpty()) {
                return null;
            }
            id = name.trim().toLowerCase().replace(' ', '-');
        }
        if (name == null || name.trim().isEmpty()) {
            name = id;
        }
        if (profileId == null || profileId.trim().isEmpty()) {
            profileId = id;
        }
        SettingsRepositoryBuilder builder = new SettingsRepositoryBuilder().setId(id.trim()).setName(name.trim()).setUrl(url);
        return new RepositoryWrapper(builder.get(), profileId.replace(' ', '-'));
    }
}

