/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.libprov;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.swt.widgets.Composite;

public class DependencyEditingSupport
extends EditingSupport {
    private static String[] scopes = new String[]{"", "provided", "compile", "test", "runtime", "system", "import"};
    private static String[] types = new String[]{"", "jar", "war", "rar", "ear", "par", "ejb", "ejb3", "ejb-client", "test-jar", "java-source", "javadoc", "maven-plugin", "pom"};
    private CellEditor editor;
    private int column;

    public DependencyEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        switch (column) {
            case 3: {
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), scopes);
                break;
            }
            case 4: {
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), types);
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            }
        }
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        Dependency dependency = (Dependency)element;
        String value = null;
        switch (this.column) {
            case 0: {
                value = dependency.getGroupId();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 1: {
                value = dependency.getArtifactId();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 2: {
                value = dependency.getVersion();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 3: {
                int i = 0;
                while (i < scopes.length) {
                    if (scopes[i].equals(dependency.getScope())) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
            case 4: {
                int i = 0;
                while (i < types.length) {
                    if (types[i].equals(dependency.getType())) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        Dependency dependency = (Dependency)element;
        String valueString = null;
        int intValue = 0;
        if (this.column < 3) {
            valueString = value == null ? null : value.toString();
        } else {
            intValue = (Integer)value;
        }
        switch (this.column) {
            case 0: {
                dependency.setGroupId(valueString);
                break;
            }
            case 1: {
                dependency.setArtifactId(valueString);
                break;
            }
            case 2: {
                dependency.setVersion(valueString);
                break;
            }
            case 3: {
                if (intValue < 0 || intValue > scopes.length) {
                    intValue = 0;
                }
                dependency.setScope(scopes[intValue]);
                break;
            }
            case 4: {
                if (intValue < 0 || intValue > types.length) {
                    intValue = 0;
                }
                dependency.setType(types[intValue]);
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

