/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.jsdt.internal.core;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.jsdt.internal.core.Trace;
import tern.scriptpath.ITernScriptPath;

public class JSDTClassPathManager
implements IElementChangedListener,
ITernProjectLifecycleListener {
    private static final String JSDT_EXTERNAL_LABEL = "jsdt";
    private static final JSDTClassPathManager INSTANCE = new JSDTClassPathManager();

    public static JSDTClassPathManager getManager() {
        return INSTANCE;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaScriptProject jsProject;
        IJavaScriptElementDelta delta = event.getDelta();
        if (delta.getKind() == 4 && (jsProject = this.getJavaScriptProjectIfClassPathChanged(delta)) != null) {
            ConfigureJob configJob = new ConfigureJob(jsProject);
            configJob.setRule((ISchedulingRule)jsProject.getProject());
            configJob.schedule();
        }
    }

    private IJavaScriptProject getJavaScriptProjectIfClassPathChanged(IJavaScriptElementDelta delta) {
        if (delta.getKind() != 4) {
            return null;
        }
        IJavaScriptElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaScriptElementDelta child = children[i];
                    IJavaScriptProject project = this.getJavaScriptProjectIfClassPathChanged(child);
                    if (project != null) {
                        return project;
                    }
                    ++i;
                }
                return null;
            }
            case 2: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        return null;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
                            return null;
                        }
                        IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IJavaScriptElementDelta child = children[i];
                            IJavaScriptProject project = this.getJavaScriptProjectIfClassPathChanged(child);
                            if (project != null) {
                                return project;
                            }
                            ++i;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 3: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        return null;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x40) > 0 || (flags & 0x80) > 0) {
                            return element.getJavaScriptProject();
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public void startup() {
        JavaScriptCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    public void shutdown() {
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
        TernCorePlugin.removeTernProjectLifeCycleListener((ITernProjectLifecycleListener)this);
    }

    public void handleEvent(IIDETernProject ternProject, ITernProjectLifecycleListener.LifecycleEventType eventType) {
        if (eventType != ITernProjectLifecycleListener.LifecycleEventType.onLoadAfter) {
            return;
        }
        IProject project = ternProject.getProject();
        if (JavaProject.hasJavaNature((IProject)project)) {
            IJavaScriptProject jsProject = JavaScriptCore.create((IProject)project);
            this.synchTernScriptPaths(jsProject, ternProject);
        }
    }

    private void synchTernScriptPaths(IJavaScriptProject jsProject, IIDETernProject ternProject) {
        try {
            ternProject.removeExternalScriptPaths(JSDT_EXTERNAL_LABEL);
            IIncludePathEntry[] entries = jsProject.getRawIncludepath();
            int i = 0;
            while (i < entries.length) {
                IIncludePathEntry entry = entries[i];
                switch (entry.getEntryKind()) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        if (entry.getPath().segmentCount() == 1) {
                            this.synchTernProjectScriptPaths(ternProject, entry);
                            break;
                        }
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath());
                        try {
                            ternProject.addExternalScriptPath((IResource)folder, ITernScriptPath.ScriptPathsType.FOLDER, JSDT_EXTERNAL_LABEL);
                        }
                        catch (IOException e) {
                            Trace.trace((byte)3, "Error while adding external tern script path for project " + ternProject.getProject().getName(), e);
                        }
                        break;
                    }
                    case 2: {
                        this.synchTernProjectScriptPaths(ternProject, entry);
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            Trace.trace((byte)3, "Error while getting JSDT ClassPath for project " + ternProject.getProject().getName(), e);
        }
    }

    private void synchTernProjectScriptPaths(IIDETernProject ternProject, IIncludePathEntry entry) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment());
        try {
            ternProject.addExternalScriptPath((IResource)project, ITernScriptPath.ScriptPathsType.PROJECT, JSDT_EXTERNAL_LABEL);
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Error while adding external tern script path for project " + ternProject.getProject().getName(), e);
        }
    }

    private class ConfigureJob
    extends WorkspaceJob {
        IJavaScriptProject fJsProject;

        private ConfigureJob(IJavaScriptProject jsProject) {
            super("Tern Project configuration job");
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IProject project;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Confuguring the project", 1);
            if (this.fJsProject != null && TernCorePlugin.hasTernNature((IProject)(project = this.fJsProject.getProject()))) {
                try {
                    IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                    JSDTClassPathManager.this.synchTernScriptPaths(this.fJsProject, ternProject);
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error while JSDT ClassPath changed.", e);
                }
            }
            monitor.worked(1);
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

