/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.core.webbrowser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import tern.eclipse.ide.tools.core.generator.Options;
import tern.eclipse.ide.tools.core.webbrowser.EditorType;
import tern.eclipse.ide.tools.core.webbrowser.TernDefLoaderType;
import tern.eclipse.ide.tools.internal.core.TernToolsCorePlugin;
import tern.repository.ITernRepository;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.IOUtils;
import tern.utils.TernModuleHelper;

public class EditorOptions
extends Options {
    private TernDefLoaderType ternDefLoaderType;
    private ITernDef[] ternDefs;
    private ITernPlugin[] ternPlugins;
    private ITernRepository repository;
    private IProject project;
    private String baseURL;
    private String editorContent;
    private final EditorType type;

    public EditorOptions(EditorType type) {
        this.type = type;
        this.ternDefLoaderType = TernDefLoaderType.EmbedDefInHTML;
    }

    public EditorType getType() {
        return this.type;
    }

    public TernDefLoaderType getTernDefLoaderType() {
        return this.ternDefLoaderType;
    }

    public void setTernDefLoaderType(TernDefLoaderType ternDefLoaderType) {
        this.ternDefLoaderType = ternDefLoaderType;
    }

    public String getEditorContent() {
        return this.editorContent;
    }

    public void setEditorContent(String editorContent) {
        this.editorContent = editorContent;
    }

    public String resolve(String uri) {
        if (this.baseURL == null) {
            try {
                return TernToolsCorePlugin.getEditorURL(this.type, uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.resolve(this.baseURL, uri);
    }

    public String resolveTern(String uri) {
        return TernModuleHelper.getPath((File)new File(this.repository.getTernBaseDir(), uri));
    }

    public String resolveTernModule(ITernModule module) {
        String fileName;
        IFile projectFile;
        File f = this.repository.getFile(module);
        if (f != null) {
            return TernModuleHelper.getPath((File)f);
        }
        if (this.project != null && (projectFile = this.project.getFile(fileName = TernModuleHelper.getFileName((ITernModule)module))).exists()) {
            return TernModuleHelper.getPath((File)projectFile.getLocation().toFile());
        }
        return null;
    }

    private String resolve(String baseURL, String uri) {
        return String.valueOf(baseURL) + uri;
    }

    public ITernDef[] getTernDefs() {
        return this.ternDefs;
    }

    public void setTernDefs(ITernDef[] ternDefs) {
        this.ternDefs = ternDefs;
    }

    public ITernPlugin[] getTernPlugins() {
        return this.ternPlugins;
    }

    public void setRepository(ITernRepository repository) {
        this.repository = repository;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String toJSONDefs() {
        StringBuilder json = new StringBuilder("[");
        if (this.ternDefs != null) {
            boolean hasQuote = this.isLoadDefWithAjax();
            ITernDef def = null;
            int i = 0;
            while (i < this.ternDefs.length) {
                def = this.ternDefs[i];
                if (i > 0) {
                    json.append(",");
                }
                if (hasQuote) {
                    json.append("\"");
                }
                json.append(def.getName());
                if (hasQuote) {
                    json.append("\"");
                }
                ++i;
            }
        }
        json.append("]");
        return json.toString();
    }

    public String toJSONPlugins() {
        StringBuilder json = new StringBuilder("{");
        if (this.ternPlugins != null) {
            ITernPlugin plugin = null;
            String options = null;
            int i = 0;
            while (i < this.ternPlugins.length) {
                plugin = this.ternPlugins[i];
                options = "{}";
                if (i > 0) {
                    json.append(",");
                }
                json.append("\"");
                json.append(plugin.getName());
                json.append("\"");
                json.append(":");
                json.append(options);
                ++i;
            }
        }
        json.append("}");
        return json.toString();
    }

    public void setTernPlugins(ITernPlugin[] ternPlugins) {
        this.ternPlugins = ternPlugins;
    }

    public String getEmbedJSONDefs() {
        if (this.ternDefs != null && this.isEmbedDefInHTML()) {
            StringBuilder js = new StringBuilder();
            js.append("<script>");
            ITernDef def = null;
            int i = 0;
            while (i < this.ternDefs.length) {
                def = this.ternDefs[i];
                String url = this.resolveTernModule((ITernModule)def);
                File f = null;
                f = url.startsWith("file:/") ? new File(url.substring("file:/".length(), url.length())) : new File(url);
                try {
                    String json = IOUtils.toString((Reader)new FileReader(f));
                    js.append("\nvar ");
                    js.append(def.getName());
                    js.append("=");
                    js.append(json);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            js.append("</script>");
            return js.toString();
        }
        return null;
    }

    public String getTernDefsScriptsToInclude() {
        if (this.ternDefs != null) {
            this.isEmbedDefInJS();
        }
        return "";
    }

    public boolean isLoadDefWithAjax() {
        return TernDefLoaderType.LoadDefWithAjax.equals((Object)this.ternDefLoaderType);
    }

    public boolean isEmbedDefInHTML() {
        return TernDefLoaderType.EmbedDefInHTML.equals((Object)this.ternDefLoaderType);
    }

    public boolean isEmbedDefInJS() {
        return TernDefLoaderType.EmbedDefInJS.equals((Object)this.ternDefLoaderType);
    }
}

