/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.html.template;

import java.util.List;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class HtmlFlashAbstractTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement wrapper = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument, (String)"div");
        String wrapperStyle = "display:inline-block;";
        if (sourceElement.hasAttribute("width")) {
            try {
                int width = Integer.parseInt(sourceElement.getAttribute("width"));
                wrapperStyle = VpeStyleUtil.setSizeInStyle((String)wrapperStyle, (String)"width", (int)width);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (sourceElement.hasAttribute("height")) {
            try {
                int height = Integer.parseInt(sourceElement.getAttribute("height"));
                wrapperStyle = VpeStyleUtil.setSizeInStyle((String)wrapperStyle, (String)"height", (int)height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        wrapper.setAttribute("style", wrapperStyle);
        nsIDOMElement objectElement = visualDocument.createElement(this.getTagName());
        wrapper.appendChild((nsIDOMNode)objectElement);
        VisualDomUtil.copyAttributes((Element)sourceElement, (nsIDOMElement)objectElement, this.getAttributesToBeCopied());
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(objectElement);
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            childrenInfo.addSourceChild(children.item(i));
            ++i;
        }
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)wrapper);
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    public abstract String getTagName();

    public abstract List<String> getAttributesToBeCopied();
}

