/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.egit.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.jboss.tools.openshift.egit.core.internal.EGitCoreActivator;
import org.jboss.tools.openshift.egit.core.internal.utils.RegexUtils;

public class EGitUtils {
    private static final String EGIT_UI_PLUGIN_ID = "org.eclipse.egit.ui";
    private static final String REMOTE_CONNECTION_TIMEOUT = "remote_connection_timeout";
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String DEFAULT_REFSPEC_SOURCE = "HEAD";
    private static final String DEFAULT_REFSPEC_DESTINATION = "refs/heads/master";
    private static final String EGIT_TEAM_PROVIDER_ID = "org.eclipse.egit.core.GitProvider";
    private static final Pattern GIT_URL_PATTERN = Pattern.compile("(\\w+://)(([^@]+)@)*(([\\w\\d\\.-]+)(:[\\d]+){0,1}/*(.*))");
    private static final Pattern GIT_SSH_URL_PATTERN = Pattern.compile("(ssh:\\/\\/){0,1}[^@]+@*[\\w\\d\\.-]+(:|\\/).+");

    private EGitUtils() {
    }

    public static boolean isShared(IProject project) {
        return RepositoryProvider.getProvider((IProject)project) != null;
    }

    public static boolean isSharedWithGit(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        return provider != null && EGIT_TEAM_PROVIDER_ID.equals(provider.getID());
    }

    public static boolean hasDotGitFolder(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        return new File(project.getLocation().toOSString(), ".git").exists();
    }

    public static boolean isGitFolderInRootOf(IProject project) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
        if (mapping == null) {
            return false;
        }
        String gitFolderRelativePath = mapping.getGitDir();
        if (StringUtils.isEmptyOrNull((String)gitFolderRelativePath)) {
            return false;
        }
        return !gitFolderRelativePath.startsWith("..");
    }

    public static Repository share(IProject project, IProgressMonitor monitor) throws CoreException {
        Repository repository = EGitUtils.createRepository(project, monitor);
        EGitUtils.connect(project, repository, monitor);
        EGitUtils.addToRepository(project, repository, monitor);
        EGitUtils.commit(project, monitor);
        return repository;
    }

    public static Repository createRepository(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            InitCommand init = Git.init();
            init.setBare(false).setDirectory(project.getLocation().toFile());
            Git git = init.call();
            return git.getRepository();
        }
        catch (JGitInternalException e) {
            throw new CoreException(EGitCoreActivator.createErrorStatus(NLS.bind((String)"Could not initialize a git repository at {0}: {1}", (Object)EGitUtils.getRepositoryPathFor(project), (Object)e.getMessage()), e));
        }
        catch (GitAPIException e) {
            throw new CoreException(EGitCoreActivator.createErrorStatus(NLS.bind((String)"Could not initialize a git repository at {0}: {1}", (Object)EGitUtils.getRepositoryPathFor(project), (Object)e.getMessage()), e));
        }
    }

    public static File getRepositoryPathFor(IProject project) {
        return new File(project.getLocationURI().getPath(), ".git");
    }

    public static void addToRepository(IProject project, Repository repository, IProgressMonitor monitor) throws CoreException {
        AddToIndexOperation add = new AddToIndexOperation(Collections.singletonList(project));
        add.execute(monitor);
    }

    public static void addToRepository(Collection<IResource> resources, IProgressMonitor monitor) throws CoreException {
        AddToIndexOperation add = new AddToIndexOperation(resources);
        add.execute(monitor);
    }

    public static void connect(IProject project, IProgressMonitor monitor) throws CoreException {
        EGitUtils.connect(project, EGitUtils.getRepositoryPathFor(project), monitor);
    }

    private static void connect(IProject project, Repository repository, IProgressMonitor monitor) throws CoreException {
        EGitUtils.connect(project, repository.getDirectory(), monitor);
    }

    private static void connect(IProject project, File repositoryFolder, IProgressMonitor monitor) throws CoreException {
        new ConnectProviderOperation(project, repositoryFolder).execute(monitor);
    }

    public static void cloneRepository(String uri, String remoteName, File destination, IProgressMonitor monitor) throws URISyntaxException, InvocationTargetException, InterruptedException {
        EGitUtils.cloneRepository(uri, remoteName, destination, null, monitor);
    }

    public static void cloneRepository(String uri, String remoteName, File destination, CloneOperation.PostCloneTask postCloneTask, IProgressMonitor monitor) throws URISyntaxException, InvocationTargetException, InterruptedException {
        URIish gitUri = new URIish(uri);
        CloneOperation cloneOperation = new CloneOperation(gitUri, true, null, destination, DEFAULT_REFSPEC_SOURCE, remoteName, EGitUtils.getEgitTimeout());
        if (postCloneTask != null) {
            cloneOperation.addPostCloneTask(postCloneTask);
        }
        cloneOperation.run(monitor);
    }

    public static void mergeWithRemote(URIish uri, String branch, Repository repository, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        RefSpec ref = new RefSpec().setSource(DEFAULT_REFSPEC_SOURCE).setDestination(branch);
        EGitUtils.fetch(uri, Collections.singletonList(ref), repository, monitor);
        EGitUtils.merge(branch, repository, monitor);
    }

    private static MergeResult merge(String branch, Repository repository, IProgressMonitor monitor) throws CoreException {
        MergeOperation merge = new MergeOperation(repository, branch, MergeStrategy.RESOLVE.getName());
        merge.execute(monitor);
        return merge.getResult();
    }

    private static Collection<Ref> fetch(URIish uri, List<RefSpec> fetchRefsRefSpecs, Repository repository, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        FetchOperation fetch = new FetchOperation(repository, uri, fetchRefsRefSpecs, 10240, false);
        fetch.run(monitor);
        FetchResult result = fetch.getOperationResult();
        return result.getAdvertisedRefs();
    }

    public static RevCommit commit(IProject project, String commitMessage, IProgressMonitor monitor) throws CoreException {
        Repository repository = EGitUtils.getRepository(project);
        Assert.isLegal((repository != null ? 1 : 0) != 0, (String)"Cannot commit project to repository. ");
        return EGitUtils.commit(project, commitMessage, repository, monitor);
    }

    public static RevCommit commit(IProject project, IProgressMonitor monitor) throws CoreException {
        return EGitUtils.commit(project, "Commit from JBoss Tools", monitor);
    }

    private static RevCommit commit(IProject project, String commitMessage, Repository repository, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((project != null ? 1 : 0) != 0, (String)"Could not commit project. No project provided");
        Assert.isLegal((repository != null ? 1 : 0) != 0, (String)MessageFormat.format("Could not commit. Project \"{0}\" is not connected to a repository (call #connect(project, repository) first)", project.getName()));
        UserConfig userConfig = EGitUtils.getUserConfig(repository);
        CommitOperation op = new CommitOperation(null, null, null, EGitUtils.getFormattedUser(userConfig.getAuthorName(), userConfig.getAuthorEmail()), EGitUtils.getFormattedUser(userConfig.getCommitterName(), userConfig.getCommitterEmail()), commitMessage);
        op.setCommitAll(true);
        op.setRepository(repository);
        op.execute(monitor);
        return op.getCommit();
    }

    public static List<URIish> getRemoteURIs(String remoteName, IProject project) throws CoreException {
        List uris = Collections.emptyList();
        RemoteConfig remoteConfig = EGitUtils.getRemoteByName(remoteName, EGitUtils.getRepository(project));
        if (remoteConfig != null) {
            uris = remoteConfig.getURIs();
        }
        return uris;
    }

    public static List<URIish> getDefaultRemoteURIs(IProject project) throws CoreException {
        RemoteConfig remoteConfig = EGitUtils.getRemoteConfig(EGitUtils.getRepository(project));
        if (remoteConfig != null) {
            return remoteConfig.getURIs();
        }
        return new ArrayList<URIish>();
    }

    public static List<URIish> getAllRemoteURIs(IProject project) throws CoreException {
        List<RemoteConfig> remoteConfigs = EGitUtils.getAllRemoteConfigs(EGitUtils.getRepository(project));
        ArrayList<URIish> uris = new ArrayList<URIish>();
        if (remoteConfigs != null) {
            for (RemoteConfig remoteConfig : remoteConfigs) {
                uris.addAll(remoteConfig.getURIs());
            }
        }
        return uris;
    }

    public static PushOperationResult push(Repository repository, IProgressMonitor monitor, OutputStream out) throws CoreException {
        return EGitUtils.push(repository, EGitUtils.getRemoteConfig(repository), false, monitor, out);
    }

    public static PushOperationResult push(Repository repository, IProgressMonitor monitor) throws CoreException {
        return EGitUtils.push(repository, monitor, null);
    }

    public static PushOperationResult push(String remote, Repository repository, IProgressMonitor monitor) throws CoreException {
        return EGitUtils.push(remote, repository, monitor, null);
    }

    public static PushOperationResult push(String remote, Repository repository, IProgressMonitor monitor, OutputStream out) throws CoreException {
        RemoteConfig remoteConfig = EGitUtils.getRemoteByName(remote, repository);
        return EGitUtils.push(repository, remoteConfig, false, monitor, out);
    }

    public static PushOperationResult pushForce(String remote, Repository repository, IProgressMonitor monitor) throws CoreException {
        return EGitUtils.pushForce(remote, repository, monitor, null);
    }

    public static PushOperationResult pushForce(String remote, Repository repository, IProgressMonitor monitor, OutputStream out) throws CoreException {
        RemoteConfig remoteConfig = EGitUtils.getRemoteByName(remote, repository);
        return EGitUtils.push(repository, remoteConfig, true, monitor, out);
    }

    private static PushOperationResult push(Repository repository, RemoteConfig remoteConfig, boolean force, IProgressMonitor monitor, OutputStream out) throws CoreException {
        try {
            if (remoteConfig == null) {
                throw new CoreException(EGitUtils.createStatus(null, "Repository \"{0}\" has no remote repository configured", repository.toString()));
            }
            PushOperation op = EGitUtils.createPushOperation(remoteConfig, repository, force, out);
            op.run(monitor);
            PushOperationResult pushResult = op.getOperationResult();
            if (EGitUtils.hasFailedEntries(pushResult)) {
                throw new CoreException(EGitCoreActivator.createErrorStatus(NLS.bind((String)"Could not push repository {0}: {1}", (Object)repository.toString(), (Object)EGitUtils.getErrors(pushResult)), null));
            }
            return pushResult;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(EGitUtils.createStatus(e, "Could not push repo {0}", repository.toString()));
        }
    }

    private static String getErrors(PushOperationResult pushResult) {
        StringBuilder builder = new StringBuilder();
        for (RemoteRefUpdate failedUpdate : EGitUtils.getFailedUpdates(pushResult)) {
            builder.append(MessageFormat.format("push from {0} to {1} was {2}", failedUpdate.getSrcRef(), failedUpdate.getRemoteName(), failedUpdate.getStatus()));
        }
        return builder.toString();
    }

    private static PushOperation createPushOperation(RemoteConfig remoteConfig, Repository repository, boolean force, OutputStream out) throws CoreException {
        Collection<URIish> pushURIs = EGitUtils.getPushURIs(remoteConfig);
        Collection<RefSpec> fetchRefSpecs = EGitUtils.getFetchRefSpec(remoteConfig);
        Collection<RefSpec> pushRefSpecs = EGitUtils.setForceUpdate(force, EGitUtils.getPushRefSpecs(remoteConfig));
        PushOperationSpecification pushSpec = EGitUtils.createPushSpec(pushURIs, pushRefSpecs, fetchRefSpecs, repository);
        PushOperation pushOperation = new PushOperation(repository, pushSpec, false, EGitUtils.getEgitTimeout());
        pushOperation.setOutputStream(out);
        return pushOperation;
    }

    private static Collection<RefSpec> getFetchRefSpec(RemoteConfig remoteConfig) {
        if (remoteConfig == null) {
            return null;
        }
        return remoteConfig.getFetchRefSpecs();
    }

    private static PushOperationSpecification createPushSpec(Collection<URIish> pushURIs, Collection<RefSpec> pushRefSpecs, Collection<RefSpec> fetchRefSpecs, Repository repository) throws CoreException {
        try {
            PushOperationSpecification pushSpec = new PushOperationSpecification();
            Collection updates = Transport.findRemoteRefUpdatesFor((Repository)repository, pushRefSpecs, fetchRefSpecs);
            if (updates.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.egit.core", "There's no local source ref that match the remote refs (local refs changed?)"));
            }
            for (URIish uri : pushURIs) {
                pushSpec.addURIRefUpdates(uri, EGitUtils.copy(updates));
            }
            return pushSpec;
        }
        catch (NotSupportedException e) {
            throw new CoreException(EGitUtils.createStatus((Exception)((Object)e), "Could not connect repository \"{0}\" to a remote", repository.toString()));
        }
        catch (IOException e) {
            throw new CoreException(EGitUtils.createStatus(e, "Could not convert remote specifications for repository \"{0}\" to a remote", repository.toString()));
        }
    }

    private static Collection<RemoteRefUpdate> copy(Collection<RemoteRefUpdate> refUpdates) throws IOException {
        ArrayList<RemoteRefUpdate> copy = new ArrayList<RemoteRefUpdate>(refUpdates.size());
        for (RemoteRefUpdate rru : refUpdates) {
            copy.add(new RemoteRefUpdate(rru, null));
        }
        return copy;
    }

    private static Collection<URIish> getPushURIs(RemoteConfig remoteConfig) {
        ArrayList<URIish> pushURIs = new ArrayList<URIish>();
        for (URIish uri : remoteConfig.getPushURIs()) {
            pushURIs.add(uri);
        }
        if (pushURIs.isEmpty() && !remoteConfig.getURIs().isEmpty()) {
            pushURIs.add((URIish)remoteConfig.getURIs().get(0));
        }
        return pushURIs;
    }

    private static List<RefSpec> getPushRefSpecs(RemoteConfig config) {
        ArrayList<RefSpec> pushRefSpecs = new ArrayList<RefSpec>();
        List remoteConfigPushRefSpecs = config.getPushRefSpecs();
        if (!remoteConfigPushRefSpecs.isEmpty()) {
            pushRefSpecs.addAll(remoteConfigPushRefSpecs);
        } else {
            pushRefSpecs.add(new RefSpec().setSource(DEFAULT_REFSPEC_SOURCE).setDestination(DEFAULT_REFSPEC_DESTINATION));
        }
        return pushRefSpecs;
    }

    private static Collection<RefSpec> setForceUpdate(boolean forceUpdate, Collection<RefSpec> refSpecs) {
        ArrayList<RefSpec> newRefSpecs = new ArrayList<RefSpec>();
        for (RefSpec refSpec : refSpecs) {
            newRefSpecs.add(refSpec.setForceUpdate(forceUpdate));
        }
        return newRefSpecs;
    }

    public static boolean hasFailedEntries(PushOperationResult pushOperationResult) {
        return !EGitUtils.getFailedUpdates(pushOperationResult).isEmpty();
    }

    public static Collection<RemoteRefUpdate> getFailedUpdates(PushOperationResult pushOperationResult) {
        ArrayList<RemoteRefUpdate> allFailedRefUpdates = new ArrayList<RemoteRefUpdate>();
        for (URIish uri : pushOperationResult.getURIs()) {
            allFailedRefUpdates.addAll(EGitUtils.getFailedUpdates(uri, pushOperationResult));
        }
        return allFailedRefUpdates;
    }

    public static Collection<RemoteRefUpdate> getFailedUpdates(URIish uri, PushOperationResult pushOperationResult) {
        return EGitUtils.getFailedUpdates(pushOperationResult.getPushResult(uri));
    }

    private static Collection<RemoteRefUpdate> getFailedUpdates(PushResult pushResult) {
        ArrayList<RemoteRefUpdate> failedRefUpdates = new ArrayList<RemoteRefUpdate>();
        if (pushResult == null || pushResult.getRemoteUpdates() == null) {
            return failedRefUpdates;
        }
        for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
            if (RemoteRefUpdate.Status.OK == update.getStatus()) continue;
            failedRefUpdates.add(update);
        }
        return failedRefUpdates;
    }

    public static Repository getRepository(IProject project) {
        Assert.isLegal((project != null ? 1 : 0) != 0, (String)"Could not get repository. No project provided");
        RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
        if (repositoryMapping == null) {
            return null;
        }
        return repositoryMapping.getRepository();
    }

    public static Repository checkedGetRepository(IProject project) throws CoreException {
        Repository repository = EGitUtils.getRepository(project);
        if (repository == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.egit.core", NLS.bind((String)"No repository found for project {0}. Please ensure it is shared via git.", (Object)project.getName())));
        }
        return repository;
    }

    private static UserConfig getUserConfig(Repository repository) throws CoreException {
        Assert.isLegal((repository != null ? 1 : 0) != 0, (String)"Could not get user configuration. No repository provided.");
        if (repository.getConfig() == null) {
            throw new CoreException(EGitUtils.createStatus(null, "no user configuration (author, committer) are present in repository \"{0}\"", repository.toString()));
        }
        return (UserConfig)repository.getConfig().get(UserConfig.KEY);
    }

    private static String getFormattedUser(String name, String email) {
        return name + " <" + email + '>';
    }

    private static RemoteConfig getRemoteConfig(Repository repository) throws CoreException {
        Assert.isLegal((repository != null ? 1 : 0) != 0, (String)"Could not get configuration. No repository provided.");
        String currentBranch = EGitUtils.getCurrentBranch(repository);
        String remote = EGitUtils.getRemoteName(currentBranch, repository);
        return EGitUtils.getRemoteByName(remote, repository);
    }

    public static RemoteConfig getRemoteByName(String remote, Repository repository) throws CoreException {
        Assert.isLegal((repository != null ? 1 : 0) != 0, (String)"Could not get configuration. No repository provided.");
        List<RemoteConfig> allRemotes = EGitUtils.getAllRemoteConfigs(repository);
        return EGitUtils.getRemoteConfig(remote, allRemotes);
    }

    private static String getCurrentBranch(Repository repository) throws CoreException {
        String branch = null;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            throw new CoreException(EGitUtils.createStatus(e, "Could not get current branch on repository \"{0}\"", repository.toString()));
        }
        return branch;
    }

    public static RemoteConfig getRemoteConfig(String name, List<RemoteConfig> remoteConfigs) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        RemoteConfig remoteConfig = null;
        for (RemoteConfig config : remoteConfigs) {
            if (name == null || !config.getName().equals(name)) continue;
            remoteConfig = config;
            break;
        }
        return remoteConfig;
    }

    public static List<RemoteConfig> getAllRemoteConfigs(Repository repository) throws CoreException {
        if (repository == null) {
            return Collections.emptyList();
        }
        try {
            return RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException e) {
            throw new CoreException(EGitUtils.createStatus(e, "Could not get all remote repositories for repository \"{0}\"", repository.toString()));
        }
    }

    public static RemoteConfig getRemoteByUrl(Pattern pattern, Repository repository) throws CoreException {
        if (repository == null) {
            return null;
        }
        for (RemoteConfig config : EGitUtils.getAllRemoteConfigs(repository)) {
            if (!EGitUtils.hasRemoteUrl(pattern, config)) continue;
            return config;
        }
        return null;
    }

    public static boolean hasRemoteUrl(Pattern pattern, Repository repository) throws CoreException {
        return EGitUtils.getRemoteByUrl(pattern, repository) != null;
    }

    public static boolean hasRemoteUrl(Pattern pattern, RemoteConfig config) {
        if (config == null) {
            return false;
        }
        for (URIish uri : config.getURIs()) {
            Matcher matcher = pattern.matcher(uri.toString());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRemote(String name, Repository repository) throws CoreException {
        return EGitUtils.getRemoteByName(name, repository) != null;
    }

    public static boolean hasRemote(String name, String url, Repository repository) throws CoreException {
        RemoteConfig remoteConfig = EGitUtils.getRemoteByName(name, repository);
        if (remoteConfig == null) {
            return false;
        }
        return EGitUtils.hasRemoteUrl(Pattern.compile(RegexUtils.toPatternString(url)), remoteConfig);
    }

    public static boolean hasMultipleRemotes(Repository repository) throws CoreException {
        return EGitUtils.getAllRemoteConfigs(repository).size() > 1;
    }

    private static String getRemoteName(String branch, Repository repository) {
        String remoteName = null;
        if (ObjectId.isId((String)branch)) {
            remoteName = "origin";
        } else {
            remoteName = repository.getConfig().getString("branch", branch, "remote");
            if (remoteName == null) {
                remoteName = "origin";
            }
        }
        return remoteName;
    }

    public static void addRemoteTo(String remoteName, String uri, Repository repository) throws MalformedURLException, URISyntaxException, IOException {
        EGitUtils.addRemoteTo(remoteName, new URIish(uri), repository);
    }

    public static void addRemoteTo(String remoteName, URIish uri, Repository repository) throws URISyntaxException, MalformedURLException, IOException {
        StoredConfig config = repository.getConfig();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        remoteConfig.update((Config)config);
        config.save();
    }

    private static IStatus createStatus(Exception e, String message, String ... arguments) throws CoreException {
        Status status = null;
        status = e == null ? new Status(4, "org.jboss.tools.openshift.egit.core", NLS.bind((String)message, (Object[])arguments)) : new Status(4, "org.jboss.tools.openshift.egit.core", NLS.bind((String)message, (Object[])arguments), (Throwable)e);
        return status;
    }

    public static boolean isDirty(IProject project, boolean includeUntracked, IProgressMonitor monitor) throws NoWorkTreeException, IOException, GitAPIException {
        return EGitUtils.isDirty(EGitUtils.getRepository(project), includeUntracked, monitor);
    }

    public static boolean isDirty(IProject project, IProgressMonitor monitor) throws NoWorkTreeException, IOException, GitAPIException {
        return EGitUtils.isDirty(EGitUtils.getRepository(project), monitor);
    }

    public static boolean isDirty(Repository repository, IProgressMonitor monitor) throws IOException {
        return EGitUtils.isDirty(repository, true, monitor);
    }

    public static boolean isDirty(Repository repository, boolean includeUntracked, IProgressMonitor monitor) throws IOException {
        return EGitUtils.countChanges(repository, includeUntracked, monitor) > 0;
    }

    public static int countChanges(Repository repository, boolean includeUntracked, IProgressMonitor monitor) throws IOException {
        Assert.isLegal((repository != null ? 1 : 0) != 0);
        Collection<String> uncommittedChanges = new GitIndexDiffBuilder(repository).changed(true).removed(true).missing(true).conflicting(true).untracked(includeUntracked).build(monitor);
        return uncommittedChanges.size();
    }

    public static boolean hasCommitsToBePushed(Repository repository) throws IOException {
        BranchTrackingStatus status = BranchTrackingStatus.of((Repository)repository, (String)"master");
        if (status == null) {
            return false;
        }
        return status.getAheadCount() > 0;
    }

    public static URIish getPushURI(RemoteConfig config) {
        if (config.getPushURIs().isEmpty()) {
            return (URIish)config.getURIs().get(0);
        }
        return (URIish)config.getPushURIs().get(0);
    }

    public static URIish getFetchURI(RemoteConfig config) {
        if (!config.getURIs().isEmpty()) {
            return (URIish)config.getURIs().get(0);
        }
        return null;
    }

    public static FetchResult fetch(RemoteConfig config, Repository repo, IProgressMonitor monitor) throws InvocationTargetException {
        FetchOperation op = null;
        if (!config.getFetchRefSpecs().isEmpty()) {
            op = new FetchOperation(repo, config, EGitUtils.getEgitTimeout(), false);
        } else {
            List<RefSpec> refSpecs = Arrays.asList(new RefSpec("+refs/heads/*:refs/remotes/" + config.getName() + "/*"));
            URIish fetchURI = EGitUtils.getFetchURI(config);
            op = new FetchOperation(repo, fetchURI, refSpecs, EGitUtils.getEgitTimeout(), false);
        }
        op.run(monitor);
        return op.getOperationResult();
    }

    public static boolean isAhead(IProject project, String remote, IProgressMonitor monitor) throws IOException, InvocationTargetException, URISyntaxException {
        return EGitUtils.isAhead(EGitUtils.getRepository(project), remote, monitor);
    }

    public static boolean isAhead(Repository repo, String remote, IProgressMonitor monitor) throws IOException, URISyntaxException, InvocationTargetException {
        BranchTrackingStatus status;
        Assert.isLegal((remote != null ? 1 : 0) != 0);
        Assert.isLegal((repo != null ? 1 : 0) != 0);
        if (remote.equals(EGitUtils.getRemote(repo.getBranch(), (Config)repo.getConfig())) && (status = BranchTrackingStatus.of((Repository)repo, (String)repo.getBranch())) != null) {
            return status.getAheadCount() > 0;
        }
        return EGitUtils.isNonTrackingBranchAhead(repo, remote, monitor);
    }

    public static String getRemote(String branch, Config config) {
        return config.getString("branch", branch, "remote");
    }

    private static boolean isNonTrackingBranchAhead(Repository repo, String remote, IProgressMonitor monitor) throws URISyntaxException, MissingObjectException, IncorrectObjectTypeException, IOException, InvocationTargetException {
        RemoteConfig remoteConfig = new RemoteConfig((Config)repo.getConfig(), remote);
        FetchResult fetchResult = EGitUtils.fetch(remoteConfig, repo, monitor);
        Ref ref = fetchResult.getAdvertisedRef(DEFAULT_REFSPEC_SOURCE);
        if (ref == null) {
            return false;
        }
        Ref currentBranchRef = repo.getRef(repo.getBranch());
        RevWalk walk = new RevWalk(repo);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)currentBranchRef.getObjectId());
        RevCommit trackingCommit = walk.parseCommit((AnyObjectId)ref.getObjectId());
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(localCommit);
        walk.markStart(trackingCommit);
        RevCommit mergeBase = walk.next();
        walk.reset();
        walk.setRevFilter(RevFilter.ALL);
        int aheadCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)localCommit, (RevCommit)mergeBase);
        return aheadCount > 0;
    }

    public static boolean isValidGitUrl(String url) {
        return GIT_SSH_URL_PATTERN.matcher(url).matches() || GIT_URL_PATTERN.matcher(url).matches();
    }

    public static String getGitHost(String gitUrl) {
        return EGitUtils.getGitUrlGroup(5, gitUrl);
    }

    public static String getGitUsername(String gitUrl) {
        return EGitUtils.getGitUrlGroup(3, gitUrl);
    }

    private static String getGitUrlGroup(int group, String gitUrl) {
        if (gitUrl == null || gitUrl.isEmpty()) {
            return null;
        }
        Matcher matcher = GIT_URL_PATTERN.matcher(gitUrl);
        if (!matcher.find() || matcher.groupCount() < 7) {
            return null;
        }
        return matcher.group(group);
    }

    private static final int getEgitTimeout() {
        return Platform.getPreferencesService().getInt(EGIT_UI_PLUGIN_ID, REMOTE_CONNECTION_TIMEOUT, 120000, null);
    }

    public static class GitIndexDiffBuilder {
        private Repository repository;
        private boolean added = true;
        private boolean changed = true;
        private boolean conflicting = true;
        private boolean missing = true;
        private boolean modified = true;
        private boolean removed = true;
        private boolean untracked = true;

        GitIndexDiffBuilder(Repository repository) {
            this.repository = repository;
        }

        public GitIndexDiffBuilder added(boolean include) {
            this.added = include;
            return this;
        }

        public GitIndexDiffBuilder changed(boolean include) {
            this.changed = include;
            return this;
        }

        public GitIndexDiffBuilder conflicting(boolean include) {
            this.conflicting = include;
            return this;
        }

        public GitIndexDiffBuilder missing(boolean include) {
            this.missing = include;
            return this;
        }

        public GitIndexDiffBuilder modified(boolean include) {
            this.modified = include;
            return this;
        }

        public GitIndexDiffBuilder removed(boolean include) {
            this.removed = include;
            return this;
        }

        public GitIndexDiffBuilder untracked(boolean include) {
            this.untracked = include;
            return this;
        }

        public Collection<String> build(IProgressMonitor monitor) throws IOException {
            HashSet<String> resources = new HashSet<String>();
            IndexDiff diff = GitIndexDiffBuilder.getIndexChanges(this.repository, monitor);
            if (diff != null) {
                if (this.added) {
                    resources.addAll(diff.getAdded());
                }
                if (this.changed) {
                    resources.addAll(diff.getChanged());
                }
                if (this.conflicting) {
                    resources.addAll(diff.getConflicting());
                }
                if (this.missing) {
                    resources.addAll(diff.getMissing());
                }
                if (this.modified) {
                    resources.addAll(diff.getModified());
                }
                if (this.removed) {
                    resources.addAll(diff.getRemoved());
                }
                if (this.untracked) {
                    resources.addAll(diff.getUntracked());
                }
            }
            return resources;
        }

        private static IndexDiff getIndexChanges(Repository repo, IProgressMonitor monitor) throws IOException {
            IndexDiff indexDiff = new IndexDiff(repo, EGitUtils.DEFAULT_REFSPEC_SOURCE, IteratorService.createInitialIterator((Repository)repo));
            if (!indexDiff.diff((ProgressMonitor)new EclipseGitProgressTransformer(monitor), 0, 0, NLS.bind((String)"Repository: {0}", (Object)repo.getDirectory().getPath()))) {
                return null;
            }
            return indexDiff;
        }
    }
}

