/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.linuxtools.docker.core.IFieldMatcher;

public class FieldMatcher
implements IFieldMatcher {
    private String rule;
    private Pattern pattern;

    public FieldMatcher(String rule) throws PatternSyntaxException {
        this.rule = rule;
        String regexRule = this.transform(rule);
        this.pattern = Pattern.compile(regexRule);
    }

    private String transform(String rule) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < rule.length()) {
            char ch = rule.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buffer.append(ch);
            } else if (ch == '*') {
                buffer.append(".*?");
            } else {
                buffer.append('\\');
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean matches(String input) {
        Matcher m = this.pattern.matcher(input);
        return m.matches();
    }

    public String toString() {
        return this.rule;
    }
}

