/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;

public class DockerImageSearchResult
implements IDockerImageSearchResult {
    private final String description;
    private final boolean official;
    private final boolean automated;
    private final String name;
    private final int starCount;

    public DockerImageSearchResult(String description, boolean official, boolean automated, String name, int starCount) {
        this.description = description;
        this.official = official;
        this.automated = automated;
        this.name = name;
        this.starCount = starCount;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isOfficial() {
        return this.official;
    }

    @Override
    public boolean isAutomated() {
        return this.automated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getStarCount() {
        return this.starCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.automated ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.official ? 1231 : 1237);
        result = 31 * result + this.starCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerImageSearchResult other = (DockerImageSearchResult)obj;
        if (this.automated != other.automated) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.official != other.official) {
            return false;
        }
        return this.starCount == other.starCount;
    }
}

