/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockerConnectionManager {
    public static final String CONNECTIONS_FILE_NAME = "dockerconnections.xml";
    private static DockerConnectionManager instance;
    private ArrayList<IDockerConnection> connections = new ArrayList();
    private ListenerList connectionManagerListeners;

    private DockerConnectionManager() {
        this.loadConnections();
    }

    public static DockerConnectionManager getInstance() {
        if (instance == null) {
            instance = new DockerConnectionManager();
        }
        return instance;
    }

    private void loadConnections() {
        block14: {
            IPath stateLocation = Activator.getDefault().getStateLocation();
            File connectionFile = stateLocation.append(CONNECTIONS_FILE_NAME).toFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (!connectionFile.exists()) break block14;
                Document d = db.parse(connectionFile);
                Element e = d.getDocumentElement();
                NodeList connectionNodes = e.getElementsByTagName("connection");
                int x = 0;
                while (x < connectionNodes.getLength()) {
                    Node n = connectionNodes.item(x);
                    NamedNodeMap attrs = n.getAttributes();
                    Node nameNode = attrs.getNamedItem("name");
                    Node uriNode = attrs.getNamedItem("uri");
                    Node usernameNode = attrs.getNamedItem("username");
                    Node certNode = attrs.getNamedItem("cert");
                    if (uriNode != null) {
                        String uri = uriNode.getNodeValue();
                        String name = nameNode.getNodeValue();
                        if (usernameNode != null) {
                            String username = usernameNode.getNodeValue();
                            String key = DockerConnection.getPreferencesKey(uri, username);
                            ISecurePreferences root = SecurePreferencesFactory.getDefault();
                            ISecurePreferences node = root.node(key);
                            try {
                                String password = node.get("password", null);
                            }
                            catch (StorageException e1) {
                                e1.printStackTrace();
                            }
                        }
                        DockerConnection.Builder builder = new DockerConnection.Builder().name(name);
                        if (uri.startsWith("unix:")) {
                            builder = builder.unixSocket(uri);
                        } else {
                            builder = builder.tcpHost(uri);
                            if (certNode != null) {
                                String cert = certNode.getNodeValue();
                                builder = builder.tcpCertPath(cert);
                            }
                        }
                        try {
                            DockerConnection connection = builder.build();
                            this.addConnection(connection);
                        }
                        catch (DockerException e1) {
                            Activator.log(e1);
                        }
                    }
                    ++x;
                }
            }
            catch (ParserConfigurationException e) {
                Activator.log(e);
            }
            catch (SAXException e) {
                Activator.log(e);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public void saveConnections() {
        try {
            IPath stateLocation = Activator.getDefault().getStateLocation();
            File ConnectionFile = stateLocation.append(CONNECTIONS_FILE_NAME).toFile();
            if (!ConnectionFile.exists()) {
                ConnectionFile.createNewFile();
            }
            if (ConnectionFile.exists()) {
                PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(ConnectionFile)));
                p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                p.println("<connections>");
                for (IDockerConnection d : this.connections) {
                    p.print("<connection name=\"" + d.getName() + "\" uri=\"" + d.getUri());
                    if (d.getUsername() != null) {
                        p.print("\" username=\"" + d.getUsername());
                    }
                    if (d.getTcpCertPath() != null) {
                        p.print("\" cert=\"" + d.getTcpCertPath());
                    }
                    p.println("\"/>");
                }
                p.println("</connections>");
                p.close();
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public IDockerConnection[] getConnections() {
        return this.connections.toArray(new IDockerConnection[this.connections.size()]);
    }

    public IDockerConnection findConnection(String name) {
        for (IDockerConnection connection : this.connections) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return null;
    }

    public void addConnection(IDockerConnection dockerConnection) throws DockerException {
        if (!dockerConnection.isOpen()) {
            dockerConnection.open(true);
        }
        this.connections.add(dockerConnection);
        this.saveConnections();
        this.notifyListeners(0);
    }

    public void removeConnection(IDockerConnection d) {
        this.connections.remove(d);
        String uri = d.getUri();
        String name = d.getName();
        for (IDockerConnection connection : this.connections) {
            if (connection.getUri().equals(uri) && connection.getName().equals(name)) break;
        }
        this.saveConnections();
        this.notifyListeners(1);
    }

    public void notifyConnectionRename() {
        this.saveConnections();
        this.notifyListeners(2);
    }

    public void addConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners == null) {
            this.connectionManagerListeners = new ListenerList(1);
        }
        this.connectionManagerListeners.add((Object)listener);
    }

    public void removeConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners != null) {
            this.connectionManagerListeners.remove((Object)listener);
        }
    }

    public void notifyListeners(int type) {
        if (this.connectionManagerListeners != null) {
            Object[] listeners = this.connectionManagerListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerConnectionManagerListener)listeners[i]).changeEvent(type);
                ++i;
            }
        }
    }
}

