/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.runtimes.integration.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.wst.server.core.IServerType;
import org.jboss.tools.as.runtimes.integration.Messages;
import org.jboss.tools.as.runtimes.integration.ServerRuntimesIntegrationActivator;
import org.jboss.tools.as.runtimes.integration.internal.IRuntimeIntegrationConstants;

public class DriverUtility
implements IRuntimeIntegrationConstants {
    private static final int HSQL_TYPE = 1;
    private static final int H2_TYPE = 2;
    public static final HashMap<String, Pair> SERVER_DRIVER_LOCATION = new HashMap();

    static {
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.32", new Pair("/server/default/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.40", new Pair("/server/default/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.42", new Pair("/server/default/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.50", new Pair("/common/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.51", new Pair("/common/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.60", new Pair("/common/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.70", new Pair("/modules/com/h2database/h2/main", 2));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.71", new Pair("/modules/com/h2database/h2/main", 2));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.wildfly.80", new Pair("/modules/system/layers/base/com/h2database/h2/main", 2));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.wildfly.90", new Pair("/modules/system/layers/base/com/h2database/h2/main", 2));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.eap.43", new Pair("/server/default/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.eap.50", new Pair("/common/lib/hsqldb.jar", 1));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.eap.60", new Pair("/modules/com/h2database/h2/main", 2));
        SERVER_DRIVER_LOCATION.put("org.jboss.ide.eclipse.as.eap.61", new Pair("/modules/system/layers/base/com/h2database/h2/main", 2));
    }

    public void createDriver(String jbossASLocation, IServerType serverType) throws DriverUtilityException {
        try {
            this.createDriver2(jbossASLocation, serverType);
        }
        catch (ConnectionProfileException cfe) {
            throw new DriverUtilityException((Exception)((Object)cfe));
        }
    }

    private void createDriver2(String jbossASLocation, IServerType serverType) throws ConnectionProfileException {
        DriverInstance driver;
        String driverPath;
        if (ProfileManager.getInstance().getProfileByName("DefaultDS") != null) {
            return;
        }
        try {
            driverPath = DriverUtility.getDriverPath(jbossASLocation, serverType);
        }
        catch (IOException e) {
            ServerRuntimesIntegrationActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.as.runtimes.integration", Messages.JBossRuntimeStartup_Cannott_create_new_HSQL_DB_Driver, (Throwable)e));
            return;
        }
        if (driverPath == null) {
            ServerRuntimesIntegrationActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.as.runtimes.integration", Messages.JBossRuntimeStartup_Cannot_create_new_DB_Driver));
        }
        if ((driver = DriverUtility.getDriver(serverType)) == null) {
            TemplateDescriptor descr = DriverUtility.getDriverTemplateDescriptor(serverType);
            PropertySetImpl instance = new PropertySetImpl(DriverUtility.getDriverName(serverType), DriverUtility.getDriverDefinitionId(serverType));
            instance.setName(DriverUtility.getDriverName(serverType));
            instance.setID(DriverUtility.getDriverDefinitionId(serverType));
            Properties props = new Properties();
            IConfigurationElement[] template = descr.getProperties();
            int i = 0;
            while (i < template.length) {
                IConfigurationElement prop = template[i];
                String id = prop.getAttribute("id");
                String value = prop.getAttribute("value");
                props.setProperty(id, value == null ? "" : value);
                ++i;
            }
            props.setProperty("org.eclipse.datatools.connectivity.db.URL", DriverUtility.getDriverUrl(serverType));
            props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", descr.getId());
            props.setProperty("jarList", driverPath);
            if (DriverUtility.usesH2(serverType)) {
                props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", "org.h2.Driver");
                props.setProperty("org.eclipse.datatools.connectivity.db.vendor", "H2 driver");
                props.setProperty("org.eclipse.datatools.connectivity.db.URL", "jdbc:h2:mem");
                props.setProperty("org.eclipse.datatools.connectivity.db.username", "sa");
            }
            instance.setBaseProperties(props);
            DriverManager.getInstance().removeDriverInstance(instance.getID());
            System.gc();
            DriverManager.getInstance().addDriverInstance((IPropertySet)instance);
        }
        if ((driver = DriverManager.getInstance().getDriverInstanceByName(DriverUtility.getDriverName(serverType))) != null && ProfileManager.getInstance().getProfileByName("DefaultDS") == null) {
            Properties props = new Properties();
            props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", DriverUtility.getDriverDefinitionId(serverType));
            props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", "");
            props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", driver.getProperty("org.eclipse.datatools.connectivity.db.driverClass"));
            props.setProperty("org.eclipse.datatools.connectivity.db.vendor", driver.getProperty("org.eclipse.datatools.connectivity.db.vendor"));
            props.setProperty("org.eclipse.datatools.connectivity.db.version", driver.getProperty("org.eclipse.datatools.connectivity.db.version"));
            props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", "Default");
            props.setProperty("org.eclipse.datatools.connectivity.db.password", "");
            props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", "false");
            props.setProperty("org.eclipse.datatools.connectivity.db.username", driver.getProperty("org.eclipse.datatools.connectivity.db.username"));
            props.setProperty("org.eclipse.datatools.connectivity.db.URL", driver.getProperty("org.eclipse.datatools.connectivity.db.URL"));
            if (DriverUtility.usesH2(serverType)) {
                ProfileManager.getInstance().createProfile("DefaultDS", Messages.JBossRuntimeStartup_The_JBoss_AS_H2_embedded_database, "org.eclipse.datatools.connectivity.db.generic.connectionProfile", props, "", false);
            } else {
                ProfileManager.getInstance().createProfile("DefaultDS", Messages.JBossRuntimeStartup_The_JBoss_AS_Hypersonic_embedded_database, "org.eclipse.datatools.enablement.hsqldb.connectionProfile", props, "", false);
            }
        }
    }

    protected static String getDriverUrl(IServerType serverType) {
        if (DriverUtility.usesH2(serverType)) {
            return "jdbc:h2:mem";
        }
        return "jdbc:hsqldb:.";
    }

    private static String getDriverDefinitionId(IServerType serverType) {
        if (DriverUtility.usesH2(serverType)) {
            return "DriverDefn.H2 DB";
        }
        return "DriverDefn.Hypersonic DB";
    }

    private static String getDriverName(IServerType serverType) {
        if (DriverUtility.usesH2(serverType)) {
            return "H2 Database";
        }
        return "Hypersonic DB";
    }

    protected static TemplateDescriptor getDriverTemplateDescriptor(IServerType serverType) {
        if (DriverUtility.usesH2(serverType)) {
            return TemplateDescriptor.getDriverTemplateDescriptor((String)"org.eclipse.datatools.connectivity.db.generic.genericDriverTemplate");
        }
        return TemplateDescriptor.getDriverTemplateDescriptor((String)"org.eclipse.datatools.enablement.hsqldb.1_8.driver");
    }

    protected static DriverInstance getDriver(IServerType serverType) {
        if (DriverUtility.usesH2(serverType)) {
            return DriverManager.getInstance().getDriverInstanceByName("H2 Database");
        }
        return DriverManager.getInstance().getDriverInstanceByName("Hypersonic DB");
    }

    private static String getDriverPath(String jbossASLocation, IServerType serverType) throws IOException {
        File[] fileList;
        Pair pair = SERVER_DRIVER_LOCATION.get(serverType.getId());
        String loc = pair.loc;
        IPath p = new Path(jbossASLocation).append(loc);
        File f = p.toFile().getCanonicalFile();
        if (f.isDirectory() && (fileList = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) != null && fileList.length > 0) {
            return fileList[0].getCanonicalPath();
        }
        return f.getCanonicalPath();
    }

    private static boolean usesH2(IServerType serverType) {
        return SERVER_DRIVER_LOCATION.get(serverType.getId()) != null && DriverUtility.SERVER_DRIVER_LOCATION.get((Object)serverType.getId()).type == 2;
    }

    public class DriverUtilityException
    extends Exception {
        public DriverUtilityException(Exception e) {
            super(e);
        }
    }

    private static class Pair {
        String loc;
        int type;

        public Pair(String loc, int type) {
            this.loc = loc;
            this.type = type;
        }
    }
}

