/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.view;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.vpe.preview.Activator;
import org.jboss.tools.vpe.preview.Messages;
import org.jboss.tools.vpe.preview.core.exceptions.BrowserErrorWrapper;
import org.jboss.tools.vpe.preview.core.exceptions.CannotOpenExternalFileException;
import org.jboss.tools.vpe.preview.core.exceptions.DomModelNotSupportedException;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.util.ActionBar;
import org.jboss.tools.vpe.preview.core.util.EditorUtil;
import org.jboss.tools.vpe.preview.core.util.NavigationUtil;
import org.jboss.tools.vpe.preview.core.util.PlatformUtil;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;
import org.jboss.tools.vpe.preview.util.ViewActionBar;

public class VpvView
extends ViewPart
implements VpvVisualModelHolder {
    public static final String ID = "org.jboss.tools.vpe.vpv.view.VpvView";
    private Browser browser;
    private ActionBar actionBar;
    private Job currentJob;
    private VpvVisualModel visualModel;
    private int modelHolderId;
    private EditorListener editorListener;
    private SelectionListener selectionListener;
    private IEditorPart currentEditor;
    private IDocumentListener documentListener;
    protected BrowserErrorWrapper errorWrapper = new BrowserErrorWrapper();

    public VpvView() {
        this.setModelHolderId(Activator.getDefault().getVisualModelHolderRegistry().registerHolder((VpvVisualModelHolder)this));
        UsageEventType eventType = Activator.getDefault().getPreviewEventType();
        UsageReporter.getInstance().countEvent(eventType.event("open"));
    }

    public void dispose() {
        if (this.editorListener != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this.editorListener);
        }
        if (this.selectionListener != null) {
            this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.selectionListener);
        }
        if (this.actionBar != null) {
            this.actionBar.dispose();
        }
        Activator.getDefault().getVisualModelHolderRegistry().unregisterHolder((VpvVisualModelHolder)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setUrl("about:blank");
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    NavigationUtil.disableJsPopUps((Browser)VpvView.this.browser);
                    NavigationUtil.disableLinks((Browser)VpvView.this.browser);
                    NavigationUtil.disableInputs((Browser)VpvView.this.browser);
                    ISelection currentSelection = VpvView.this.getCurrentSelection();
                    NavigationUtil.updateSelectionAndScrollToIt((ISelection)currentSelection, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel);
                }
            });
            this.browser.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    NavigationUtil.navigateToVisual((IEditorPart)VpvView.this.currentEditor, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel, (int)event.x, (int)event.y);
                }
            });
            this.inizializeSelectionListener();
            this.inizializeEditorListener(this.browser, this.modelHolderId);
            IActionBars bars = this.getViewSite().getActionBars();
            this.actionBar = new ViewActionBar(this.browser, Activator.getDefault().getPreferenceStore(), this);
            this.actionBar.fillLocalToolBar(bars.getToolBarManager());
        }
        catch (Throwable t) {
            this.errorWrapper.showError(parent, t);
        }
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void setVisualModel(VpvVisualModel visualModel) {
        this.visualModel = visualModel;
    }

    public void setModelHolderId(int modelHolderId) {
        this.modelHolderId = modelHolderId;
    }

    public IEditorPart getCurrentEditor() {
        return this.currentEditor;
    }

    public void editorChanged(IEditorPart editor) {
        this.removeErrorMessage();
        this.changeControlVisibility((Control)this.browser, true);
        this.browser.getParent().setLayout((Layout)new FillLayout());
        if (this.currentEditor != editor) {
            if (editor == null) {
                this.browser.setUrl("about:blank");
                this.setCurrentEditor(null);
            } else if (EditorUtil.isImportant((IEditorPart)editor)) {
                this.formRequestToServer(editor);
                this.setCurrentEditor(editor);
            } else {
                this.browser.setUrl("about:blank");
                this.setCurrentEditor(null);
                if (SuitableFileExtensions.isHTML((String)EditorUtil.getFileExtensionFromEditor((IEditorPart)editor))) {
                    this.changeControlVisibility((Control)this.browser, false);
                    this.errorWrapper.showError(this.browser.getParent(), (Throwable)new DomModelNotSupportedException(org.jboss.tools.vpe.preview.core.exceptions.Messages.EDITOR_DOES_NOT_SUPPORT_DOM_MODEL));
                }
            }
        }
    }

    private void inizializeEditorListener(Browser browser, int modelHolderId) {
        this.editorListener = new EditorListener();
        this.getSite().getPage().addPartListener((IPartListener2)this.editorListener);
        this.editorListener.showBootstrapPart();
    }

    private void inizializeSelectionListener() {
        this.selectionListener = new SelectionListener();
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.selectionListener);
    }

    private void setCurrentEditor(IEditorPart currentEditor) {
        IDocument document;
        if (this.currentEditor != null && (document = (IDocument)this.currentEditor.getAdapter(IDocument.class)) != null) {
            document.removeDocumentListener(this.getDocumentListener());
        }
        this.currentEditor = currentEditor;
        if (this.currentEditor != null) {
            document = (IDocument)this.currentEditor.getAdapter(IDocument.class);
            String fileExtension = EditorUtil.getFileExtensionFromEditor((IEditorPart)this.currentEditor);
            if (document == null && SuitableFileExtensions.isCssOrJs((String)fileExtension)) {
                document = ((AbstractDecoratedTextEditor)this.currentEditor).getDocumentProvider().getDocument((Object)currentEditor.getEditorInput());
            }
            if (document != null) {
                document.addDocumentListener(this.getDocumentListener());
            }
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (VpvView.this.actionBar.isAutomaticRefreshEnabled()) {
                        String fileExtension = EditorUtil.getFileExtensionFromEditor((IEditorPart)VpvView.this.currentEditor);
                        if (SuitableFileExtensions.isCssOrJs((String)fileExtension)) {
                            VpvView.this.currentEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        VpvView.this.updatePreview();
                    }
                }
            };
        }
        return this.documentListener;
    }

    private Job createPreviewUpdateJob() {
        UIJob job = new UIJob("Preview Update"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!VpvView.this.browser.isDisposed()) {
                    VpvView.this.refresh(VpvView.this.browser);
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private void updatePreview() {
        if (this.currentJob == null || this.currentJob.getState() != 2) {
            if (this.currentJob != null && this.currentJob.getState() == 1) {
                this.currentJob.cancel();
            }
            this.currentJob = this.createPreviewUpdateJob();
        }
        this.currentJob.schedule(500L);
    }

    private void refresh(Browser browser) {
        String url = browser.getUrl();
        if (PlatformUtil.isWindows()) {
            String ext = EditorUtil.getFileExtensionFromEditor((IEditorPart)this.currentEditor);
            if (SuitableFileExtensions.isCssOrJs((String)ext)) {
                browser.refresh();
            } else {
                browser.setUrl(NavigationUtil.fixUrl((Browser)browser));
            }
        } else {
            browser.setUrl(url);
        }
    }

    private ISelection getCurrentSelection() {
        Activator activator = Activator.getDefault();
        IWorkbench workbench = activator.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        return selection;
    }

    private boolean isCurrentEditor(IEditorPart editorPart) {
        return this.currentEditor == editorPart;
    }

    private void formRequestToServer(IEditorPart editor) {
        IFile file = EditorUtil.getFileOpenedInEditor((IEditorPart)editor);
        String fileExtension = null;
        this.removeErrorMessage();
        if (file != null && file.exists()) {
            fileExtension = file.getFileExtension();
            if (SuitableFileExtensions.contains((String)fileExtension) && SuitableFileExtensions.isHTML((String)fileExtension)) {
                try {
                    String url = EditorUtil.formUrl((IFile)file, (int)this.modelHolderId, (String)Integer.toString(Activator.getDefault().getServer().getPort()));
                    this.browser.setUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.logError(e);
                }
            }
        } else if (editor != null) {
            if (editor.getEditorInput() instanceof IPathEditorInput) {
                try {
                    IPath externalFile = ((IPathEditorInput)editor.getEditorInput()).getPath();
                    String url = EditorUtil.formUrl((IPath)externalFile, (int)this.modelHolderId, (String)Integer.toString(Activator.getDefault().getServer().getPort()));
                    this.browser.setUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.logError(e);
                }
            } else if (editor.getEditorInput() instanceof FileStoreEditorInput) {
                try {
                    String externalFile = ((FileStoreEditorInput)editor.getEditorInput()).getURI().getPath();
                    String url = EditorUtil.formUrl((String)externalFile, (int)this.modelHolderId, (String)Integer.toString(Activator.getDefault().getServer().getPort()));
                    this.browser.setUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.logError(e);
                }
            } else {
                this.changeControlVisibility((Control)this.browser, false);
                this.errorWrapper.showError(this.browser.getParent(), (Throwable)new CannotOpenExternalFileException(MessageFormat.format(org.jboss.tools.vpe.preview.core.exceptions.Messages.CANNOT_SHOW_EXTERNAL_FILE, Messages.VISUAL_PREVIEW)));
                this.browser.setUrl("about:blank");
            }
        }
        this.browser.getParent().layout();
    }

    private void changeControlVisibility(Control c, boolean visible) {
        GridData data = new GridData();
        data.exclude = !visible;
        c.setLayoutData((Object)data);
        c.setVisible(visible);
    }

    private void removeErrorMessage() {
        Control[] children;
        Control[] controlArray = children = this.browser.getParent().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.equals(this.browser)) {
                c.dispose();
            }
            ++n2;
        }
    }

    private class EditorListener
    implements IPartListener2 {
        private EditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof EditorReference) {
                IEditorPart editor = ((EditorReference)partRef).getEditor(false);
                VpvView.this.editorChanged(editor);
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IEditorPart editorPart;
            if (partRef instanceof EditorReference && VpvView.this.isCurrentEditor(editorPart = ((EditorReference)partRef).getEditor(false))) {
                VpvView.this.editorChanged(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            IEditorPart editor;
            IWorkbenchPage page = partRef.getPage();
            if (page != null && (editor = page.getActiveEditor()) != null) {
                VpvView.this.formRequestToServer(editor);
                VpvView.this.setCurrentEditor(editor);
            }
        }

        public void showBootstrapPart() {
            IEditorPart activeEditor = EditorUtil.getActivePage().getActiveEditor();
            VpvView.this.editorChanged(activeEditor);
        }
    }

    private class SelectionListener
    implements ISelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection && EditorUtil.isInCurrentEditor((IStructuredSelection)((IStructuredSelection)selection), (IEditorPart)VpvView.this.currentEditor)) {
                NavigationUtil.updateSelectionAndScrollToIt((ISelection)selection, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel);
            }
        }
    }
}

