/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.oaametadata.Method;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding declaringClass;
    char[] signature;
    public long tagBits;
    public FunctionTypeBinding functionTypeBinding;
    public ReferenceBinding allocationType;
    public Method oaaMethod;
    private MethodBinding fOriginal;

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] parameters, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.setParameters(parameters == null || parameters.length == 0 ? Binding.NO_PARAMETERS : parameters);
        this.declaringClass = declaringClass;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] parameters, ReferenceBinding declaringClass) {
        this(modifiers, TypeConstants.INIT, TypeBinding.UNKNOWN, parameters, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.declaringClass = declaringClass;
        this.fOriginal = initialMethodBinding;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.parameters[i] != args[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] arguments) {
        int argLength;
        int paramLength = this.parameters.length;
        int lastIndex = argLength = arguments.length;
        if (this.isVarargs()) {
            TypeBinding varArgType;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                varArgType = this.parameters[lastIndex];
                TypeBinding lastArgument = arguments[lastIndex];
                if (varArgType != lastArgument && !lastArgument.isCompatibleWith(varArgType)) {
                    return false;
                }
            } else if (paramLength < argLength) {
                varArgType = ((ArrayBinding)this.parameters[lastIndex]).elementsType();
                int i = lastIndex;
                while (i < argLength) {
                    if (varArgType != arguments[i] && !arguments[i].isCompatibleWith(varArgType)) {
                        return false;
                    }
                    ++i;
                }
            } else if (lastIndex != argLength) {
                return false;
            }
        }
        int i = 0;
        while (i < lastIndex) {
            if (this.parameters[i] != arguments[i] && !arguments[i].isCompatibleWith(this.parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = this.declaringClass;
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass && invocationType == receiverType) {
            return true;
        }
        if (invocationType == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (invocationType == this.declaringClass) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            TypeBinding receiverErasure = receiverType;
            ReferenceBinding declaringErasure = this.declaringClass;
            int depth = 0;
            do {
                if (currentType.findSuperTypeWithSameErasure(declaringErasure) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (currentType == receiverErasure || receiverErasure.findSuperTypeWithSameErasure(currentType) != null) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (receiverType != this.declaringClass) {
                return false;
            }
            if (invocationType != this.declaringClass) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding declaringPackage = null;
        if (this.declaringClass != null && invocationType.fPackage != (declaringPackage = this.declaringClass.fPackage)) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        do {
            if (this.declaringClass == currentType) {
                return true;
            }
            if (currentType == null) {
                return true;
            }
            PackageBinding currentPackage = currentType.fPackage;
            if (currentPackage == null || currentPackage == declaringPackage) continue;
            return false;
        } while ((currentType = currentType.getSuperBinding()) != null);
        return false;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        char[] declaringKey = this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int selectorLength = this.selector == TypeConstants.INIT || this.selector == null ? 0 : this.selector.length;
        char[] sig = this.signature();
        int signatureLength = sig.length;
        char[] uniqueKey = new char[declaringLength + 1 + selectorLength + signatureLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index = declaringLength;
        uniqueKey[index++] = 46;
        if (this.selector != null) {
            System.arraycopy(this.selector, 0, uniqueKey, index, selectorLength);
        }
        System.arraycopy(sig, 0, uniqueKey, index += selectorLength, signatureLength);
        return uniqueKey;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public Object getDefaultValue() {
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x8000000000000L) == 0L) {
            originalMethod.tagBits |= 0x8000000000000L;
        }
        return null;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT || (this.tagBits & 0x20000000000000L) != 0L;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this.fOriginal != null ? this.fOriginal : this;
    }

    @Override
    public char[] readableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    public void setDefaultValue(Object defaultValue) {
        MethodBinding originalMethod = this.original();
        originalMethod.tagBits |= 0x8000000000000L;
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
                ++i;
            }
        }
        buffer.append(')');
        int nameLength = buffer.length();
        char[] shortReadableName = new char[nameLength];
        buffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    public final char[] signature() {
        int i;
        boolean needSynthetics;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType();
        if (targetParameters != Binding.NO_PARAMETERS) {
            i = 0;
            while (i < targetParameters.length) {
                buffer.append(targetParameters[i].signature());
                ++i;
            }
        }
        if (needSynthetics) {
            i = targetParameters.length;
            int extraLength = this.parameters.length;
            while (i < extraLength) {
                buffer.append(this.parameters[i].signature());
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return method.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceType;
        try {
            sourceType = (SourceTypeBinding)this.original().declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (sourceType != null) {
            return sourceType.sourceMethod(this.original());
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return method.sourceStart;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.returnType != null ? this.returnType.debugName() : "NULL TYPE");
        s.append(this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        s.append('(');
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                int i = 0;
                int length = this.parameters.length;
                while (i < length) {
                    if (i > 0) {
                        s.append(',').append(' ');
                    }
                    s.append(this.parameters[i] != null ? this.parameters[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s.append("NULL PARAMETERS");
        }
        s.append(") ");
        return s.toString();
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public void createFunctionTypeBinding(Scope scope) {
        this.functionTypeBinding = new FunctionTypeBinding(this, scope);
    }

    public MethodBinding createNamedMethodBinding(char[] name) {
        MethodBinding newBinding = new MethodBinding(this.modifiers, name, this.returnType, this.parameters, this.declaringClass);
        newBinding.functionTypeBinding = this.functionTypeBinding;
        newBinding.tagBits = this.tagBits;
        newBinding.signature = this.signature;
        return newBinding;
    }

    public void updateFrom(MethodBinding functionBinding) {
        this.returnType = functionBinding.returnType;
        this.parameters = functionBinding.parameters;
    }

    public void cleanup() {
        if (this.functionTypeBinding != null) {
            this.functionTypeBinding.cleanup();
        }
    }

    protected void setParameters(TypeBinding[] params) {
        this.parameters = params;
        if (this.fOriginal != null) {
            this.fOriginal.parameters = params;
        }
    }

    public TypeBinding[] getParameters() {
        TypeBinding[] params = Binding.NO_PARAMETERS;
        if (this.parameters != null && this.parameters.length > 0) {
            params = this.parameters;
        } else if (this.fOriginal.parameters != null && this.fOriginal.parameters.length > 0) {
            params = this.fOriginal.parameters;
        }
        return params;
    }

    void ensureBindingsAreComplete() {
        if (this.declaringClass instanceof SourceTypeBinding) {
            SourceTypeBinding parentBinding = (SourceTypeBinding)this.declaringClass;
            if ((parentBinding.tagBits & 0x8000L) == 0L) {
                parentBinding.methods();
            }
        }
    }
}

