/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewDockerConnectionPage
extends WizardPage {
    private EnumDockerConnectionSettings bindingMode;
    private String connectionName = null;
    private String unixSocketPath = null;
    private String tcpHost = null;
    private boolean tcpTLSVerify = false;
    private String tcpCertPath = null;
    private Control[] bindingModeSelectionControls;
    private Control[] unixSocketControls;
    private Control[] tcpConnectionControls;
    private Control[] tcpAuthControls;
    private Text connectionNameText;
    private Button customConnectionSettingsButton;
    private Button unixSocketSelectionButton;
    private Text unixSocketPathText;
    private Button tcpConnectionSelectionButton;
    private Text tcpHostText;
    private Button tcpAuthButton;
    private Text tcpCertPathText;

    public NewDockerConnectionPage() {
        super("NewDockerConnectionPage", WizardMessages.getString("NewDockerConnectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("NewDockerConnectionPage.msg"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createConnectionSettingsContainer(container);
        this.setControl((Control)container);
        this.retrieveDefaultConnectionSettings();
        this.setDefaultControlValues();
    }

    private void createConnectionSettingsContainer(Composite parent) {
        int COLUMNS = 3;
        int INDENT = 20;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo(container);
        Label connectionNameLabel = new Label(container, 0);
        connectionNameLabel.setText(WizardMessages.getString("NewDockerConnectionPage.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)connectionNameLabel);
        this.connectionNameText = new Text(container, 2048);
        this.connectionNameText.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.nameTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.connectionNameText);
        this.customConnectionSettingsButton = new Button(container, 32);
        this.customConnectionSettingsButton.setText("Use custom connection settings:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 10).span(3, 1).applyTo((Control)this.customConnectionSettingsButton);
        this.customConnectionSettingsButton.setSelection(false);
        Group customSettingsGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, false).applyTo((Control)customSettingsGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo((Composite)customSettingsGroup);
        this.unixSocketSelectionButton = new Button((Composite)customSettingsGroup, 16);
        this.unixSocketSelectionButton.setText(WizardMessages.getString("NewDockerConnectionPage.unixSocket"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)this.unixSocketSelectionButton);
        Label unixSocketPathLabel = new Label((Composite)customSettingsGroup, 0);
        unixSocketPathLabel.setText(WizardMessages.getString("NewDockerConnectionPage.location"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)unixSocketPathLabel);
        this.unixSocketPathText = new Text((Composite)customSettingsGroup, 2048);
        this.unixSocketPathText.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.unixPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.unixSocketPathText);
        Button unixSocketPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        unixSocketPathBrowseButton.setText(WizardMessages.getString("NewDockerConnectionPage.browseButton"));
        unixSocketPathBrowseButton.addSelectionListener(this.onBrowseUnixSocketPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)unixSocketPathBrowseButton);
        this.tcpConnectionSelectionButton = new Button((Composite)customSettingsGroup, 16);
        this.tcpConnectionSelectionButton.setText(WizardMessages.getString("NewDockerConnectionPage.tcpConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)this.tcpConnectionSelectionButton);
        Label tcpHostLabel = new Label((Composite)customSettingsGroup, 0);
        tcpHostLabel.setText(WizardMessages.getString("NewDockerConnectionPage.hostLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)tcpHostLabel);
        this.tcpHostText = new Text((Composite)customSettingsGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.tcpHostText);
        this.tcpAuthButton = new Button((Composite)customSettingsGroup, 32);
        this.tcpAuthButton.setText(WizardMessages.getString("NewDockerConnectionPage.tcpAuthButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).applyTo((Control)this.tcpAuthButton);
        Label tcpCertPathLabel = new Label((Composite)customSettingsGroup, 0);
        tcpCertPathLabel.setText(WizardMessages.getString("NewDockerConnectionPage.tcpPathLabel"));
        tcpCertPathLabel.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.tcpPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)tcpCertPathLabel);
        this.tcpCertPathText = new Text((Composite)customSettingsGroup, 2048);
        this.tcpCertPathText.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.tcpCertPathText);
        Button tcpCertPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        tcpCertPathBrowseButton.setText(WizardMessages.getString("NewDockerConnectionPage.browseButton"));
        tcpCertPathBrowseButton.addSelectionListener(this.onBrowseTcpCertPathFile());
        this.tcpCertPathText.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)tcpCertPathBrowseButton);
        Button testConnectionButton = new Button(container, 0);
        testConnectionButton.setText(WizardMessages.getString("NewDockerConnectionPage.testConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)testConnectionButton);
        testConnectionButton.addSelectionListener(this.onTestConnectionButtonSelection());
        this.bindingModeSelectionControls = new Control[]{this.unixSocketSelectionButton, this.tcpConnectionSelectionButton};
        this.unixSocketControls = new Control[]{this.unixSocketPathText, unixSocketPathLabel, unixSocketPathBrowseButton};
        this.tcpConnectionControls = new Control[]{this.tcpHostText, tcpHostLabel, this.tcpAuthButton};
        this.tcpAuthControls = new Control[]{this.tcpCertPathText, tcpCertPathLabel, tcpCertPathBrowseButton};
        this.customConnectionSettingsButton.addSelectionListener((SelectionListener)this.onCustomConnectionSettingsSelection());
        this.connectionNameText.addModifyListener(this.onConnectionNameModification());
        this.unixSocketSelectionButton.addSelectionListener((SelectionListener)this.onUnixSocketSelection());
        this.unixSocketPathText.addModifyListener(this.onUnixSocketModification());
        this.tcpConnectionSelectionButton.addSelectionListener((SelectionListener)this.onTcpConnectionSelection());
        this.tcpAuthButton.addSelectionListener((SelectionListener)this.onTcpAuthSelection());
        this.tcpHostText.addModifyListener(this.onTcpHostModification());
        this.tcpCertPathText.addModifyListener(this.onTcpCertPathModification());
        this.setWidgetsEnabled(false, new Control[][]{this.bindingModeSelectionControls, this.unixSocketControls, this.tcpConnectionControls, this.tcpAuthControls});
    }

    private SelectionListener onBrowseUnixSocketPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(NewDockerConnectionPage.this.getShell());
                String selectedPath = fileDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.unixSocketPathText.setText(selectedPath);
                }
            }
        };
    }

    private SelectionListener onBrowseTcpCertPathFile() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewDockerConnectionPage.this.getShell());
                String selectedPath = directoryDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.tcpCertPathText.setText(selectedPath);
                }
            }
        };
    }

    private void retrieveDefaultConnectionSettings() {
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(WizardMessages.getString("NewDockerConnectionPage.retrieveTask"), 1);
                    try {
                        DockerConnection.Defaults defaults = new DockerConnection.Defaults();
                        NewDockerConnectionPage.this.bindingMode = defaults.getBindingMode();
                        NewDockerConnectionPage.this.connectionName = defaults.getName();
                        NewDockerConnectionPage.this.unixSocketPath = defaults.getUnixSocketPath();
                        NewDockerConnectionPage.this.tcpHost = defaults.getTcpHost();
                        NewDockerConnectionPage.this.tcpTLSVerify = defaults.getTcpTlsVerify();
                        NewDockerConnectionPage.this.tcpCertPath = defaults.getTcpCertPath();
                        NewDockerConnectionPage.this.connectionName = defaults.getName();
                    }
                    catch (DockerException e) {
                        Activator.log(e);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private void setDefaultControlValues() {
        if (this.connectionName != null) {
            this.connectionNameText.setText(this.connectionName);
        }
        if (this.bindingMode == EnumDockerConnectionSettings.UNIX_SOCKET) {
            this.unixSocketSelectionButton.setSelection(true);
            if (this.unixSocketPath != null) {
                this.unixSocketPathText.setText(this.unixSocketPath);
            }
        } else {
            this.tcpConnectionSelectionButton.setSelection(true);
            if (this.tcpHost != null) {
                this.tcpHostText.setText(this.tcpHost);
            }
            if (this.tcpTLSVerify) {
                this.setWidgetsEnabled(true, this.tcpAuthControls);
                this.tcpAuthButton.setSelection(true);
                this.tcpCertPathText.setEnabled(true);
                if (this.tcpCertPath != null) {
                    this.tcpCertPathText.setText(this.tcpCertPath);
                }
            }
            this.unixSocketSelectionButton.setSelection(false);
        }
        this.setWidgetsEnabled(false, new Control[][]{this.tcpConnectionControls, this.tcpAuthControls});
        this.setWidgetsEnabled(false, this.unixSocketControls);
        this.connectionNameText.setFocus();
    }

    private SelectionAdapter onCustomConnectionSettingsSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button targetButton = (Button)e.widget;
                if (targetButton.getSelection()) {
                    NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.bindingModeSelectionControls);
                    if (NewDockerConnectionPage.this.bindingMode == EnumDockerConnectionSettings.UNIX_SOCKET) {
                        NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.unixSocketControls);
                    } else {
                        if (NewDockerConnectionPage.this.tcpTLSVerify) {
                            NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.tcpAuthControls);
                        }
                        NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.tcpConnectionControls);
                    }
                } else {
                    NewDockerConnectionPage.this.setWidgetsEnabled(false, new Control[][]{NewDockerConnectionPage.this.unixSocketControls, NewDockerConnectionPage.this.tcpConnectionControls, NewDockerConnectionPage.this.tcpAuthControls});
                }
            }
        };
    }

    private SelectionAdapter onUnixSocketSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button targetButton = (Button)e.widget;
                if (targetButton.getSelection()) {
                    NewDockerConnectionPage.this.bindingMode = EnumDockerConnectionSettings.UNIX_SOCKET;
                    NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.unixSocketControls);
                } else {
                    NewDockerConnectionPage.this.setWidgetsEnabled(false, NewDockerConnectionPage.this.unixSocketControls);
                }
            }
        };
    }

    private SelectionAdapter onTcpConnectionSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button targetButton = (Button)e.widget;
                if (targetButton.getSelection()) {
                    NewDockerConnectionPage.this.bindingMode = EnumDockerConnectionSettings.TCP_CONNECTION;
                    if (NewDockerConnectionPage.this.tcpTLSVerify) {
                        NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.tcpAuthControls);
                    }
                    NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.tcpConnectionControls);
                } else {
                    NewDockerConnectionPage.this.setWidgetsEnabled(false, NewDockerConnectionPage.this.tcpConnectionControls);
                    NewDockerConnectionPage.this.setWidgetsEnabled(false, NewDockerConnectionPage.this.tcpAuthControls);
                }
            }
        };
    }

    private SelectionAdapter onTcpAuthSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button targetButton = (Button)e.widget;
                if (targetButton.getSelection()) {
                    NewDockerConnectionPage.this.tcpTLSVerify = true;
                    NewDockerConnectionPage.this.setWidgetsEnabled(true, NewDockerConnectionPage.this.tcpAuthControls);
                } else {
                    NewDockerConnectionPage.this.tcpTLSVerify = false;
                    NewDockerConnectionPage.this.setWidgetsEnabled(false, NewDockerConnectionPage.this.tcpAuthControls);
                }
            }
        };
    }

    private void setWidgetsEnabled(boolean enabled, Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
        if (controls.length > 0 && enabled) {
            controls[0].setFocus();
        }
    }

    private void setWidgetsEnabled(boolean enabled, Control[] ... controlGroups) {
        Control[][] controlArray = controlGroups;
        int n = controlGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Control[] controlGroup;
            Control[] controlArray2 = controlGroup = controlArray[n2];
            int n3 = controlGroup.length;
            int n4 = 0;
            while (n4 < n3) {
                Control control = controlArray2[n4];
                control.setEnabled(enabled);
                ++n4;
            }
            ++n2;
        }
    }

    private ModifyListener onConnectionNameModification() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NewDockerConnectionPage.this.connectionName = ((Text)evt.widget).getText();
            }
        };
    }

    private ModifyListener onUnixSocketModification() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NewDockerConnectionPage.this.unixSocketPath = ((Text)evt.widget).getText();
            }
        };
    }

    private ModifyListener onTcpHostModification() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NewDockerConnectionPage.this.tcpHost = ((Text)evt.widget).getText();
            }
        };
    }

    private ModifyListener onTcpCertPathModification() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NewDockerConnectionPage.this.tcpCertPath = ((Text)evt.widget).getText();
            }
        };
    }

    private SelectionListener onTestConnectionButtonSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(1);
                try {
                    NewDockerConnectionPage.this.getWizard().getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask(WizardMessages.getString("NewDockerConnectionPage.pingTask"), -1);
                            try {
                                DockerConnection dockerConnection = NewDockerConnectionPage.this.getDockerConnection();
                                dockerConnection.open(false);
                                dockerConnection.ping();
                                dockerConnection.close();
                                resultQueue.add(true);
                            }
                            catch (DockerException e) {
                                Activator.log(e);
                                resultQueue.add(false);
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException o_O) {
                    Activator.log(o_O);
                }
                try {
                    Boolean result = (Boolean)resultQueue.poll(5000L, TimeUnit.MILLISECONDS);
                    if (result.booleanValue()) {
                        new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.success"), null, WizardMessages.getString("NewDockerConnectionPage.pingSuccess"), 2, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                    } else {
                        new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.failure"), null, WizardMessages.getString("NewDockerConnectionPage.pingFailure"), 1, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                    }
                }
                catch (InterruptedException o_O) {
                    new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.failure"), null, WizardMessages.getString("NewDockerConnectionPage.pingFailure"), 1, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                }
            }
        };
    }

    protected DockerConnection getDockerConnection() {
        if (this.bindingMode == EnumDockerConnectionSettings.UNIX_SOCKET) {
            return new DockerConnection.Builder().name(this.connectionName).unixSocket(this.unixSocketPath).build();
        }
        if (this.tcpTLSVerify) {
            return new DockerConnection.Builder().name(this.connectionName).tcpHost(this.tcpHost).tcpCertPath(this.tcpCertPath).build();
        }
        return new DockerConnection.Builder().name(this.connectionName).tcpHost(this.tcpHost).build();
    }
}

