/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageTagPage
extends WizardPage {
    private static final String NAME = "ImageTag.name";
    private static final String TITLE = "ImageTag.title";
    private static final String DESC = "ImageTag.desc";
    private static final String TAG_LABEL = "ImageTagName.label";
    private static final String TAG_TOOLTIP = "ImageTagName.toolTip";
    private Text tagText;
    private String tag;
    private ModifyListener Listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImageTagPage.this.validate();
        }
    };

    public ImageTagPage(String image) {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getTag() {
        return this.tag;
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String tagField = this.tagText.getText().trim();
        if (tagField.length() == 0) {
            complete = false;
        }
        if (!error) {
            this.setErrorMessage(null);
            this.tag = tagField;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(TAG_LABEL));
        this.tagText = new Text(container, 2052);
        this.tagText.addModifyListener(this.Listener);
        this.tagText.setToolTipText(WizardMessages.getString(TAG_TOOLTIP));
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.tagText.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment(0, 0);
        repoLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11);
        f.left = new FormAttachment((Control)repoLabel, 5);
        f.right = new FormAttachment(100);
        this.tagText.setLayoutData((Object)f);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }
}

