/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageSearchModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageSearchPage
extends WizardPage {
    private final ImageSearchModel model;
    private Button searchImageButton;
    private final DataBindingContext ctx = new DataBindingContext();

    public ImageSearchPage(ImageSearchModel model) {
        super("ImageSearchPage", WizardMessages.getString("ImageSearchPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageSearchPage.title"));
        this.model = model;
    }

    public void dispose() {
        this.ctx.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        int COLUMNS = 3;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo(container);
        Label searchImageLabel = new Label(container, 0);
        searchImageLabel.setText(WizardMessages.getString("ImageSearchPage.imageLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)searchImageLabel);
        Text searchImageText = new Text(container, 2944);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)searchImageText);
        searchImageText.addKeyListener(this.onKeyPressed());
        searchImageText.addTraverseListener(this.onSearchImageTextTraverse());
        this.searchImageButton = new Button(container, 0);
        this.searchImageButton.setText(WizardMessages.getString("ImageSearchPage.search"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.searchImageButton);
        this.searchImageButton.addSelectionListener(this.onSearchImageButtonSelected());
        this.searchImageButton.setEnabled(!searchImageText.getText().isEmpty());
        Label searchResultLabel = new Label(container, 0);
        searchResultLabel.setText(WizardMessages.getString("ImageSearchPage.searchResultLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)searchResultLabel);
        Table table = new Table(container, 68352);
        final TableViewer searchResultTableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColum(searchResultTableViewer, WizardMessages.getString("ImageSearchPage.nameColumn"), 0, 131072, 290, (CellLabelProvider)new ImageNameColumnLabelProvider());
        this.addTableViewerColum(searchResultTableViewer, WizardMessages.getString("ImageSearchPage.starsColumn"), 0, 131072, 70, (CellLabelProvider)new ImageStarsColumnLabelProvider());
        this.addTableViewerColum(searchResultTableViewer, WizardMessages.getString("ImageSearchPage.officialColumn"), 0, 0x1000000, 70, (CellLabelProvider)new ImageOfficialColumnLabelProvider());
        this.addTableViewerColum(searchResultTableViewer, WizardMessages.getString("ImageSearchPage.automatedColumn"), 0, 0x1000000, 70, (CellLabelProvider)new ImageAutomatedColumnLabelProvider());
        searchResultTableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).hint(200, 100).applyTo((Control)table);
        Group selectedImageDescriptionGroup = new Group(container, 2048);
        selectedImageDescriptionGroup.setText(WizardMessages.getString("ImageSearchPage.descriptionGroup"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(3, 1).applyTo((Control)selectedImageDescriptionGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).spacing(10, 2).applyTo((Composite)selectedImageDescriptionGroup);
        Label selectedImageDescription = new Label((Composite)selectedImageDescriptionGroup, 64);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(200, 100).applyTo((Control)selectedImageDescription);
        IObservableValue observableTermModel = BeanProperties.value(ImageSearchModel.class, (String)"term").observe((Object)this.model);
        this.ctx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)searchImageText), observableTermModel);
        observableTermModel.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                String term = (String)event.getObservableValue().getValue();
                if (term.isEmpty()) {
                    ImageSearchPage.this.searchImageButton.setEnabled(false);
                } else {
                    ImageSearchPage.this.searchImageButton.setEnabled(true);
                }
            }
        });
        IObservableList observableSearchResultModel = BeanProperties.list(ImageSearchModel.class, (String)"searchResult").observe((Object)this.model);
        observableSearchResultModel.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                searchResultTableViewer.setInput((Object)event.getObservable());
            }
        });
        this.ctx.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)searchResultTableViewer), BeanProperties.value((String)"selectedImage").observe((Object)this.model));
        IObservableValue observableSelectedImageDescription = PojoProperties.value((String)"description", String.class).observeDetail((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)searchResultTableViewer));
        this.ctx.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)selectedImageDescription), observableSelectedImageDescription);
        searchImageText.setFocus();
        this.setControl((Control)parent);
    }

    private TableViewerColumn addTableViewerColum(TableViewer tableViewer, String title, int style, int alignment, int width, CellLabelProvider columnLabelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setAlignment(alignment);
        column.setWidth(width);
        viewerColumn.setLabelProvider(columnLabelProvider);
        return viewerColumn;
    }

    private TraverseListener onSearchImageTextTraverse() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    e.doit = false;
                }
            }
        };
    }

    private KeyListener onKeyPressed() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r' && !ImageSearchPage.this.model.getTerm().isEmpty()) {
                    ImageSearchPage.this.searchImages();
                }
            }
        };
    }

    private SelectionListener onSearchImageButtonSelected() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageSearchPage.this.searchImages();
            }
        };
    }

    private void searchImages() {
        final String term = this.model.getTerm();
        if (term.isEmpty()) {
            return;
        }
        try {
            final ArrayBlockingQueue searchResultQueue = new ArrayBlockingQueue(1);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(WizardMessages.getString("ImageSearchPage.searchTask"), 1);
                    try {
                        List searchResults = ImageSearchPage.this.model.getSelectedConnection().searchImages(term);
                        monitor.beginTask(WizardMessages.getString("ImageSearchPage.searchTask"), 1);
                        searchResultQueue.offer(searchResults);
                    }
                    catch (DockerException e) {
                        Activator.log(e);
                    }
                    monitor.done();
                }
            });
            final List searchResult = (List)searchResultQueue.poll(10L, TimeUnit.SECONDS);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageSearchPage.this.model.setSearchResult(searchResult);
                    ImageSearchPage.this.getWizard().getContainer().updateButtons();
                }
            });
            if (searchResult.isEmpty()) {
                this.setMessage(WizardMessages.getString("ImageSearchPage.noImageWarning"), 2);
            } else if (searchResult.size() == 1) {
                this.setMessage(WizardMessages.getString("ImageSearchPage.oneImageMatched"), 1);
            } else {
                this.setMessage(WizardMessages.getFormattedString("ImageSearchPage.imagesMatched", Integer.toString(searchResult.size())), 1);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    public boolean isPageComplete() {
        return this.model.getSelectedImage() != null;
    }

    static abstract class IconColumnLabelProvider
    extends StyledCellLabelProvider {
        private static final Image ICON = SWTImagesFactory.DESC_CHECKED.createImage();

        IconColumnLabelProvider() {
        }

        protected void measure(Event event, Object element) {
            Rectangle rectangle = ICON.getBounds();
            event.setBounds(new Rectangle(event.x, event.y, rectangle.width + 200, rectangle.height));
        }

        protected void paint(Event event, Object element) {
            TableColumn column = ((TableViewerColumn)this.getColumn()).getColumn();
            int columnWidth = column.getWidth();
            if (this.doPaint(element)) {
                Rectangle bounds = event.getBounds();
                event.gc.drawImage(ICON, bounds.x + (columnWidth - IconColumnLabelProvider.ICON.getBounds().width) / 2, bounds.y + 1);
            }
        }

        abstract boolean doPaint(Object var1);
    }

    static class ImageAutomatedColumnLabelProvider
    extends IconColumnLabelProvider {
        ImageAutomatedColumnLabelProvider() {
        }

        @Override
        boolean doPaint(Object element) {
            return element instanceof IDockerImageSearchResult && ((IDockerImageSearchResult)element).isAutomated();
        }
    }

    static class ImageNameColumnLabelProvider
    extends ColumnLabelProvider {
        ImageNameColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IDockerImageSearchResult) {
                return ((IDockerImageSearchResult)element).getName();
            }
            return super.getText(element);
        }
    }

    static class ImageOfficialColumnLabelProvider
    extends IconColumnLabelProvider {
        ImageOfficialColumnLabelProvider() {
        }

        @Override
        boolean doPaint(Object element) {
            return element instanceof IDockerImageSearchResult && ((IDockerImageSearchResult)element).isOfficial();
        }
    }

    static class ImageStarsColumnLabelProvider
    extends ColumnLabelProvider {
        ImageStarsColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IDockerImageSearchResult) {
                return Integer.toString(((IDockerImageSearchResult)element).getStarCount());
            }
            return super.getText(element);
        }
    }
}

