/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;

public class ImageSearchModel
extends BaseDatabindingModel {
    public static final String TERM = "term";
    public static final String SELECTED_IMAGE = "selectedImage";
    public static final String SEARCH_RESULT = "searchResult";
    private final IDockerConnection selectedConnection;
    private String term = null;
    private IDockerImageSearchResult selectedImage;
    private List<IDockerImageSearchResult> searchResult;

    public ImageSearchModel(IDockerConnection selectedConnection) {
        this.selectedConnection = selectedConnection;
    }

    public IDockerConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
        this.firePropertyChange(TERM, this.term, this.term);
    }

    public IDockerImageSearchResult getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(IDockerImageSearchResult selectedImage) {
        this.selectedImage = selectedImage;
        this.firePropertyChange(SELECTED_IMAGE, this.selectedImage, this.selectedImage);
    }

    public List<IDockerImageSearchResult> getSearchResult() {
        return this.searchResult;
    }

    public void setSearchResult(List<IDockerImageSearchResult> searchResult) {
        this.searchResult = searchResult;
        this.firePropertyChange(SEARCH_RESULT, this.searchResult, this.searchResult);
        if (!this.searchResult.isEmpty()) {
            this.setSelectedImage(this.searchResult.get(0));
        }
    }
}

