/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageRemoveTagPage
extends WizardPage {
    private static final String NAME = "ImageRemoveTag.name";
    private static final String TITLE = "ImageRemoveTag.title";
    private static final String DESC = "ImageRemoveTag.desc";
    private static final String REMOVE_TAG_LABEL = "ImageRemoveTagName.label";
    private static final String REMOVE_TAG_TOOLTIP = "ImageRemoveTagName.toolTip";
    private Combo tagCombo;
    private IDockerImage image;

    public ImageRemoveTagPage(IDockerImage image) {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
        this.image = image;
    }

    public String getTag() {
        return this.tagCombo.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(REMOVE_TAG_LABEL));
        this.tagCombo = new Combo(container, 2056);
        this.tagCombo.setToolTipText(WizardMessages.getString(REMOVE_TAG_TOOLTIP));
        List repoTags = this.image.repoTags();
        this.tagCombo.setItems(repoTags.toArray(new String[0]));
        this.tagCombo.select(0);
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.tagCombo.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment(0, 0);
        repoLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11);
        f.left = new FormAttachment((Control)repoLabel, 5);
        f.right = new FormAttachment(100);
        this.tagCombo.setLayoutData((Object)f);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }
}

