/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImagePushPage
extends WizardPage {
    private static final String NAME = "ImagePush.name";
    private static final String TITLE = "ImagePush.title";
    private static final String DESC = "ImagePush.desc";
    private static final String NAME_LABEL = "ImagePushName.label";
    private static final String NAME_TOOLTIP = "ImagePushName.toolTip";
    private Text nameText;
    private Combo nameCombo;
    private IDockerImage image;
    private String tag;
    private ModifyListener Listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImagePushPage.this.validate();
        }
    };

    public ImagePushPage() {
        this(null);
    }

    public ImagePushPage(IDockerImage image) {
        super(WizardMessages.getString(NAME));
        this.image = image;
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getImageTag() {
        return this.tag;
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String name = null;
        name = this.nameText != null ? this.nameText.getText() : this.nameCombo.getText();
        if (name.length() == 0) {
            complete = false;
        }
        if (!error) {
            this.setErrorMessage(null);
            this.tag = name;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(WizardMessages.getString(NAME_LABEL));
        Text c = null;
        if (this.image == null || this.image.repoTags().size() == 0) {
            this.nameText = new Text(container, 2052);
            this.nameText.addModifyListener(this.Listener);
            this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
            c = this.nameText;
        } else {
            this.nameCombo = new Combo(container, 12);
            this.nameCombo.addModifyListener(this.Listener);
            this.nameCombo.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
            List repoTags = this.image.repoTags();
            this.nameCombo.setItems(repoTags.toArray(new String[0]));
            this.nameCombo.setText((String)repoTags.get(0));
            c = this.nameCombo;
        }
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.nameText != null ? this.nameText.computeSize(-1, -1) : this.nameCombo.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment((Control)nameLabel, 5);
        f.right = new FormAttachment(100);
        c.setLayoutData((Object)f);
        this.setControl((Control)container);
        this.setPageComplete(this.nameText == null);
    }
}

