/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImagePullPage
extends WizardPage {
    private static final String NAME = "ImagePull.name";
    private static final String TITLE = "ImagePull.title";
    private static final String DESC = "ImagePull.desc";
    private static final String NAME_LABEL = "ImagePullName.label";
    private static final String NAME_TOOLTIP = "ImagePullName.toolTip";
    private static final String NAME_EMPTY_RULE = "ErrorNameEmpty.msg";
    private static final String INVALID_ID = "ErrorInvalidImageId.msg";
    private Text nameText;
    private String image;
    private ModifyListener Listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImagePullPage.this.validate();
        }
    };

    public ImagePullPage() {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getImageId() {
        return this.image;
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        String name = this.nameText.getText();
        if (name.length() == 0) {
            this.setErrorMessage(WizardMessages.getString(NAME_EMPTY_RULE));
            error = true;
        } else if (name.charAt(name.length() - 1) == ':') {
            this.setErrorMessage(WizardMessages.getString(INVALID_ID));
            error = true;
        } else if (name.contains(":") && name.substring(name.indexOf(":") + 1).contains(":")) {
            this.setErrorMessage(WizardMessages.getString(INVALID_ID));
            error = true;
        }
        if (!error) {
            this.setErrorMessage(null);
            this.image = name;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(NAME_LABEL));
        this.nameText = new Text(container, 2052);
        this.nameText.addModifyListener(this.Listener);
        this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.nameText.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment(0, 0);
        repoLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment((Control)repoLabel, 5);
        f.right = new FormAttachment(100);
        this.nameText.setLayoutData((Object)f);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }
}

