/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContainerCommitPage
extends WizardPage {
    private static final String NAME = "ContainerCommit.name";
    private static final String TITLE = "ContainerCommit.title";
    private static final String DESC = "ContainerCommit.desc";
    private static final String COMMIT_LABEL = "ContainerCommit.label";
    private static final String NAME_LABEL = "Name.label";
    private static final String NAME_TOOLTIP = "ImageName.toolTip";
    private static final String AUTHOR_LABEL = "Author.label";
    private static final String COMMENT_LABEL = "Comment.label";
    private static final String INVALID_REPO_ID = "ErrorInvalidRepo.msg";
    private String repo;
    private String tag;
    private Text nameText;
    private Text authorText;
    private Text commentText;
    private ModifyListener Listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ContainerCommitPage.this.validate();
        }
    };

    public ContainerCommitPage(String container) {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getFormattedString(DESC, container.substring(0, 8)));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public String getRepo() {
        return this.repo;
    }

    public String getTag() {
        return this.tag;
    }

    public String getAuthor() {
        return this.authorText.getText();
    }

    public String getComment() {
        return this.commentText.getText();
    }

    private void validate() {
        boolean complete = true;
        boolean error = false;
        if (this.nameText.getText().length() == 0) {
            complete = false;
        }
        if (!error) {
            String[] tokens = this.nameText.getText().split(":");
            if (tokens.length == 2) {
                this.repo = tokens[0];
                this.tag = tokens[1];
                this.setErrorMessage(null);
            } else if (tokens.length == 1) {
                this.repo = tokens[0];
                this.tag = "";
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(WizardMessages.getString(INVALID_REPO_ID));
            }
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(WizardMessages.getString(COMMIT_LABEL));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(WizardMessages.getString(NAME_LABEL));
        this.nameText = new Text(composite, 2052);
        this.nameText.addModifyListener(this.Listener);
        this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
        Label authorLabel = new Label(composite, 0);
        authorLabel.setText(WizardMessages.getString(AUTHOR_LABEL));
        this.authorText = new Text(composite, 2052);
        this.authorText.addModifyListener(this.Listener);
        Label commentLabel = new Label(composite, 0);
        commentLabel.setText(WizardMessages.getString(COMMENT_LABEL));
        this.commentText = new Text(composite, 2052);
        this.commentText.addModifyListener(this.Listener);
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.nameText.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        Label prevControl = label;
        Label longestLabel = commentLabel;
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11 + centering);
        f.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11);
        f.left = new FormAttachment((Control)longestLabel, 5);
        f.right = new FormAttachment(100);
        this.nameText.setLayoutData((Object)f);
        prevControl = nameLabel;
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11 + centering);
        f.left = new FormAttachment(0, 0);
        authorLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11);
        f.left = new FormAttachment((Control)longestLabel, 5);
        f.right = new FormAttachment(100);
        this.authorText.setLayoutData((Object)f);
        prevControl = authorLabel;
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11 + centering);
        f.left = new FormAttachment(0, 0);
        commentLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)prevControl, 11);
        f.left = new FormAttachment((Control)longestLabel, 5);
        f.right = new FormAttachment(100);
        this.commentText.setLayoutData((Object)f);
        prevControl = commentLabel;
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }
}

