/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;

public class DockerImagesContentProvider
implements ITreeContentProvider {
    private static final String LoadingImages = "ImagesLoadJob.msg";
    private static final Object[] EMPTY = new Object[0];
    private TableViewer viewer;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDockerConnection) {
            IDockerConnection connection = (IDockerConnection)inputElement;
            if (connection.isImagesLoaded()) {
                return connection.getImages().toArray();
            }
            this.loadImages(connection);
            return EMPTY;
        }
        return EMPTY;
    }

    private void loadImages(final IDockerConnection connection) {
        Job loadImagesJob = new Job(DVMessages.getString(LoadingImages)){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        connection.getImages(true);
                        DockerImagesContentProvider.this.viewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        loadImagesJob.schedule();
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }
}

