/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerExplorerView
extends CommonNavigator
implements IDockerConnectionManagerListener,
ITabbedPropertySheetPageContributor {
    private static final String NO_CONNECTION_LABEL = "NoConnection.label";
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerExplorerView";
    private Control connectionsPane;
    private Control explanationsPane;
    private PageBook pageBook;
    private Map<IDockerConnection, DockerContainersRefresher> containersRefreshers = new HashMap<IDockerConnection, DockerContainersRefresher>();
    private Text search;
    private ViewerFilter containersAndImagesSearchFilter;

    protected Object getInitialInput() {
        return DockerConnectionManager.getInstance();
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        this.setLinkingEnabled(false);
        return viewer;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        DockerConnectionManager.getInstance().removeConnectionManagerListener((IDockerConnectionManagerListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        this.connectionsPane = this.createConnectionsPane(this.pageBook, toolkit);
        this.explanationsPane = this.createExplanationPane(this.pageBook, toolkit);
        this.showConnectionsOrExplanations();
        this.containersAndImagesSearchFilter = this.getContainersAndImagesSearchFilter();
        this.getCommonViewer().addFilter(this.containersAndImagesSearchFilter);
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
    }

    private ViewerFilter getContainersAndImagesSearchFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDockerContainer || element instanceof IDockerImage) {
                    return element.toString().contains(DockerExplorerView.this.search.getText());
                }
                return true;
            }
        };
    }

    private Control createConnectionsPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        super.createPartControl(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.getCommonViewer().getControl());
        return form;
    }

    private ModifyListener onSearch() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreePath[] treePaths;
                CommonViewer viewer = DockerExplorerView.this.getCommonViewer();
                TreePath[] treePathArray = treePaths = viewer.getExpandedTreePaths();
                int n = treePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath treePath = treePathArray[n2];
                    Object lastSegment = treePath.getLastSegment();
                    if (lastSegment instanceof DockerExplorerContentProvider.DockerContainersCategory || lastSegment instanceof DockerExplorerContentProvider.DockerImagesCategory) {
                        viewer.refresh(lastSegment);
                        viewer.expandToLevel((Object)treePath, -1);
                    }
                    ++n2;
                }
            }
        };
    }

    private Control createExplanationPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        Link link = new Link(container, 0);
        link.setText(DVMessages.getFormattedString(NO_CONNECTION_LABEL, new String[0]));
        link.setBackground(pageBook.getDisplay().getSystemColor(25));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)this.onExplanationClicked());
        return form;
    }

    private SelectionAdapter onExplanationClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDockerConnection wizard = new NewDockerConnection();
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    DockerExplorerView.this.getCommonViewer().refresh();
                }
            }
        };
    }

    private void showConnectionsOrExplanations() {
        if (DockerConnectionManager.getInstance().getConnections().length < 1) {
            this.pageBook.showPage(this.explanationsPane);
        } else {
            this.pageBook.showPage(this.connectionsPane);
            this.registerListeners();
        }
    }

    public void changeEvent(int type) {
        this.showConnectionsOrExplanations();
        switch (type) {
            case 0: {
                this.registerListeners();
                break;
            }
            case 1: {
                this.unregisterListeners();
            }
        }
    }

    private void registerListeners() {
        IDockerConnection[] iDockerConnectionArray = DockerConnectionManager.getInstance().getConnections();
        int n = iDockerConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            if (!this.containersRefreshers.containsKey(connection)) {
                DockerContainersRefresher containerRefresher = new DockerContainersRefresher();
                connection.addContainerListener((IDockerContainerListener)containerRefresher);
                this.containersRefreshers.put(connection, containerRefresher);
            }
            ++n2;
        }
    }

    private void unregisterListeners() {
        IDockerConnection[] iDockerConnectionArray = DockerConnectionManager.getInstance().getConnections();
        int n = iDockerConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            if (this.containersRefreshers.containsKey(connection)) {
                DockerContainersRefresher dockerContainersRefresher = this.containersRefreshers.get(connection);
                connection.removeContainerListener((IDockerContainerListener)dockerContainersRefresher);
                this.containersRefreshers.remove(connection);
            }
            ++n2;
        }
    }

    class DockerContainersRefresher
    implements IDockerContainerListener {
        DockerContainersRefresher() {
        }

        public void listChanged(final IDockerConnection connection, List<IDockerContainer> list) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection selection = DockerExplorerView.this.getCommonViewer().getSelection();
                    if (selection != null) {
                        DockerExplorerView.this.getCommonViewer().setSelection(selection, false);
                    }
                    DockerExplorerView.this.getCommonViewer().refresh((Object)connection, true);
                }
            });
        }
    }

    class DockerImagesRefresher
    implements IDockerImageListener {
        DockerImagesRefresher() {
        }

        public void listChanged(final IDockerConnection connection, List<IDockerImage> list) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection selection = DockerExplorerView.this.getCommonViewer().getSelection();
                    if (selection != null) {
                        DockerExplorerView.this.getCommonViewer().setSelection(selection, false);
                    }
                    DockerExplorerView.this.getCommonViewer().refresh((Object)connection, true);
                }
            });
        }
    }
}

