/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.swt.widgets.Display;

public class DockerExplorerContentProvider
implements ITreeContentProvider {
    private final Object[] EMPTY = new Object[0];
    private TreeViewer viewer;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DockerConnectionManager) {
            DockerConnectionManager connectionManager = (DockerConnectionManager)inputElement;
            return connectionManager.getConnections();
        }
        return this.EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IDockerConnection) {
            IDockerConnection dockerConnection = (IDockerConnection)parentElement;
            return new Object[]{new DockerImagesCategory(dockerConnection), new DockerContainersCategory(dockerConnection)};
        }
        if (parentElement instanceof DockerContainersCategory) {
            DockerContainersCategory containersCategory = (DockerContainersCategory)parentElement;
            IDockerConnection connection = containersCategory.getConnection();
            if (connection.isContainersLoaded()) {
                return connection.getContainers().toArray();
            }
            this.loadContainers(containersCategory);
            return new Object[]{new LoadingStub(containersCategory)};
        }
        if (parentElement instanceof DockerImagesCategory) {
            DockerImagesCategory imagesCategory = (DockerImagesCategory)parentElement;
            IDockerConnection connection = imagesCategory.getConnection();
            if (connection.isImagesLoaded()) {
                return connection.getImages().toArray();
            }
            this.loadImages(imagesCategory);
            return new Object[]{new LoadingStub(imagesCategory)};
        }
        return this.EMPTY;
    }

    private void loadContainers(final DockerContainersCategory containersCategory) {
        Job loadContainersJob = new Job("Loading containers..."){

            protected IStatus run(IProgressMonitor monitor) {
                containersCategory.getConnection().getContainers(true);
                return Status.OK_STATUS;
            }
        };
        loadContainersJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DockerExplorerContentProvider.this.refreshTarget(containersCategory);
                    }
                });
            }
        });
        loadContainersJob.schedule();
    }

    private void loadImages(final DockerImagesCategory imagesCategory) {
        Job loadImagesJob = new Job("Loading images..."){

            protected IStatus run(IProgressMonitor monitor) {
                imagesCategory.getConnection().getImages(true);
                return Status.OK_STATUS;
            }
        };
        loadImagesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DockerExplorerContentProvider.this.refreshTarget(imagesCategory);
            }
        });
        loadImagesJob.schedule();
    }

    public Object getParent(Object element) {
        if (element instanceof DockerImagesCategory) {
            return ((DockerImagesCategory)element).getConnection();
        }
        if (element instanceof DockerContainersCategory) {
            return ((DockerContainersCategory)element).getConnection();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IDockerConnection || element instanceof DockerContainersCategory || element instanceof DockerImagesCategory;
    }

    private void refreshTarget(final Object target) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DockerExplorerContentProvider.this.viewer != null) {
                    TreePath[] treePaths = DockerExplorerContentProvider.this.viewer.getExpandedTreePaths();
                    DockerExplorerContentProvider.this.viewer.refresh(target, true);
                    DockerExplorerContentProvider.this.viewer.setExpandedTreePaths(treePaths);
                }
            }
        });
    }

    public static class DockerContainersCategory {
        private final IDockerConnection connection;

        public DockerContainersCategory(IDockerConnection connection) {
            this.connection = connection;
        }

        public IDockerConnection getConnection() {
            return this.connection;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerContainersCategory other = (DockerContainersCategory)obj;
            return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
        }
    }

    public static class DockerImagesCategory {
        private final IDockerConnection connection;

        public DockerImagesCategory(IDockerConnection connection) {
            this.connection = connection;
        }

        public IDockerConnection getConnection() {
            return this.connection;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerImagesCategory other = (DockerImagesCategory)obj;
            return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
        }
    }

    public static class LoadingStub {
        private final Object element;

        public LoadingStub(Object element) {
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }
    }
}

