/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.ui.preferences.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DockerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String REFRESH_TIME_MSG = "RefreshTime.label";
    private IntegerFieldEditor refreshTimeField;

    public DockerPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    private void savePreferences() {
        if (this.refreshTimeField != null) {
            this.refreshTimeField.store();
        }
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    protected void performApply() {
        this.savePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createContainerRefreshContainer(container);
        return container;
    }

    private void createContainerRefreshContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(10, 2).applyTo(container);
        this.refreshTimeField = new IntegerFieldEditor("containerRefreshTime", Messages.getString(REFRESH_TIME_MSG), container);
        this.refreshTimeField.setPreferenceStore(this.getPreferenceStore());
        this.refreshTimeField.setValidateStrategy(0);
        this.refreshTimeField.setValidRange(5, 200);
        this.refreshTimeField.load();
        this.refreshTimeField.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getSource().equals(DockerPreferencePage.this.refreshTimeField)) {
                    DockerContainerRefreshManager.getInstance().setRefreshTime((long)DockerPreferencePage.this.refreshTimeField.getIntValue());
                }
            }
        });
    }
}

