/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class UnpauseContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final String CONTAINERS_UNPAUSE_MSG = "ContainersUnpause.msg";
    private static final String CONTAINER_UNPAUSE_MSG = "ContainerUnpause.msg";
    private static final String CONTAINER_UNPAUSE_ERROR_MSG = "ContainerUnpauseError.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            RunConsole console = CommandUtils.getRunConsole(connection, container);
            if (console != null) {
                console.showConsole();
                connection.unpauseContainer(container.id(), console.getOutputStream());
            } else {
                connection.unpauseContainer(container.id(), null);
            }
            connection.getContainers(true);
        }
        catch (InterruptedException | DockerException e) {
            String errorMessage = DVMessages.getFormattedString(CONTAINER_UNPAUSE_ERROR_MSG, container.id());
            this.openError(errorMessage, (Exception)e);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_UNPAUSE_MSG);
    }

    @Override
    String getTaskName(IDockerContainer container) {
        return DVMessages.getFormattedString(CONTAINER_UNPAUSE_MSG, container.name());
    }
}

