/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRun;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunImageCommandHandler
extends AbstractHandler {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = RunImageCommandHandler.getSelectedImage(activePart);
        if (selectedImage == null) {
            Activator.logErrorMessage(DVMessages.getString("RunImageUnableToRetrieveError.msg"));
        } else {
            try {
                ImageRun wizard = new ImageRun(selectedImage);
                boolean runImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
                if (runImage) {
                    DockerContainerConfig containerConfig = wizard.getDockerContainerConfig();
                    IDockerHostConfig hostConfig = wizard.getDockerHostConfig();
                    this.runImage(selectedImage.getConnection(), (IDockerContainerConfig)containerConfig, hostConfig, wizard.getDockerContainerName());
                }
            }
            catch (DockerException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    private void runImage(final IDockerConnection connection, final IDockerContainerConfig containerConfig, final IDockerHostConfig hostConfig, final String containerName) {
        if (containerConfig.tty()) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
            }
            catch (PartInitException e) {
                Activator.log(e);
            }
        }
        Job runImageJob = new Job(DVMessages.getString("RunImageCreateContainer.job")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString("RunImageRunningTask.msg"), 2);
                try {
                    SubProgressMonitor createContainerMonitor = new SubProgressMonitor(monitor, 1);
                    createContainerMonitor.beginTask(DVMessages.getString("RunImageCreatingContainerTask.msg"), 1);
                    String containerId = ((DockerConnection)connection).createContainer(containerConfig, containerName);
                    IDockerContainer container = ((DockerConnection)connection).getContainer(containerId);
                    createContainerMonitor.done();
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        SubProgressMonitor startContainerMonitor = new SubProgressMonitor(monitor, 1);
                        startContainerMonitor.beginTask(DVMessages.getString("RunImageStartingContainerTask.msg"), 1);
                        RunConsole console = CommandUtils.getRunConsole(connection, container);
                        if (console != null) {
                            console.showConsole();
                        }
                        ((DockerConnection)connection).startContainer(containerId, hostConfig, console.getOutputStream());
                        startContainerMonitor.done();
                    }
                    catch (InterruptedException | DockerException e) {
                        Display.getDefault().syncExec(new Runnable((Exception)e){
                            private final /* synthetic */ Exception val$e;
                            {
                                this.val$e = exception;
                            }

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_CREATING_CONTAINER, containerConfig.image()), (String)this.val$e.getMessage());
                            }
                        });
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        runImageJob.schedule();
    }

    public static IDockerImage getSelectedImage(IWorkbenchPart activePart) {
        IStructuredSelection selection;
        if (activePart instanceof DockerExplorerView) {
            ITreeSelection selection2 = (ITreeSelection)((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return (IDockerImage)selection2.getFirstElement();
        }
        if (activePart instanceof DockerImagesView && !(selection = (IStructuredSelection)((DockerImagesView)activePart).getSelection()).isEmpty()) {
            return (IDockerImage)selection.getFirstElement();
        }
        return null;
    }
}

