/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.views.ImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class PullImageCommandHandler
extends AbstractHandler {
    private static final String PULL_IMAGE_JOB_TITLE = "ImagePull.title";
    private static final String PULL_IMAGE_JOB_TASK = "ImagePull.msg";
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";
    private IDockerConnection connection;

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ImagePull wizard = new ImagePull();
        boolean pullImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (pullImage) {
            if (activePart instanceof DockerImagesView) {
                this.connection = ((DockerImagesView)activePart).getConnection();
            }
            this.performPullImage(wizard);
        }
        return null;
    }

    private void performPullImage(final ImagePull wizard) {
        Job pullImageJob = new Job(DVMessages.getFormattedString(PULL_IMAGE_JOB_TITLE, wizard.getImageId())){

            protected IStatus run(IProgressMonitor monitor) {
                final String id = wizard.getImageId();
                monitor.beginTask(DVMessages.getString(PullImageCommandHandler.PULL_IMAGE_JOB_TASK), -1);
                try {
                    try {
                        ((DockerConnection)PullImageCommandHandler.this.connection).pullImage(id, (IDockerProgressHandler)new ImagePullProgressHandler(PullImageCommandHandler.this.connection, id));
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(PullImageCommandHandler.ERROR_PULLING_IMAGE, id), (String)e.getMessage());
                            }
                        });
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        pullImageJob.schedule();
    }
}

