/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class PauseContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final String CONTAINERS_PAUSE_MSG = "ContainersPause.msg";
    private static final String CONTAINER_PAUSE_MSG = "ContainerPause.msg";
    private static final String CONTAINER_PAUSE_ERROR_MSG = "ContainerPauseError.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            connection.pauseContainer(container.id());
            connection.getContainers(true);
        }
        catch (InterruptedException | DockerException e) {
            String errorMessage = DVMessages.getFormattedString(CONTAINER_PAUSE_ERROR_MSG, container.id());
            this.openError(errorMessage, (Exception)e);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_PAUSE_MSG);
    }

    @Override
    String getTaskName(IDockerContainer container) {
        return DVMessages.getFormattedString(CONTAINER_PAUSE_MSG, container.name());
    }
}

