/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCommit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CommitContainerCommandHandler
extends AbstractHandler {
    private static final String COMMIT_CONTAINER_JOB_TITLE = "ContainerCommitTitle.msg";
    private static final String COMMIT_CONTAINER_MSG = "ContainerCommit.msg";
    private static final String ERROR_COMMITTING_CONTAINER = "ContainerCommitError.msg";
    private IDockerConnection connection;
    private IDockerContainer container;

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (activePart instanceof DockerContainersView) {
            this.connection = ((DockerContainersView)activePart).getConnection();
        }
        if (selectedContainers.size() != 1 || this.connection == null) {
            return null;
        }
        this.container = selectedContainers.get(0);
        ContainerCommit wizard = new ContainerCommit(this.container.id());
        boolean commitContainer = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (commitContainer) {
            this.performCommitContainer(wizard);
        }
        return null;
    }

    private void performCommitContainer(final ContainerCommit wizard) {
        Job commitContainerJob = new Job(DVMessages.getString(COMMIT_CONTAINER_JOB_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                String tag = wizard.getTag();
                String repo = wizard.getRepo();
                String author = wizard.getAuthor();
                String comment = wizard.getComment();
                monitor.beginTask(DVMessages.getString(CommitContainerCommandHandler.COMMIT_CONTAINER_MSG), 1);
                try {
                    try {
                        ((DockerConnection)CommitContainerCommandHandler.this.connection).commitContainer(CommitContainerCommandHandler.this.container.id(), repo, tag, comment, author);
                        monitor.worked(1);
                    }
                    catch (DockerException e) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(CommitContainerCommandHandler.ERROR_COMMITTING_CONTAINER, tag), (String)e.getMessage());
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        commitContainerJob.schedule();
    }
}

