/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.views.ImageBuildProgressHandler;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageBuild;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class BuildImageCommandHandler
extends AbstractHandler {
    private static final String BUILD_IMAGE_JOB_TITLE = "ImageBuild.msg";
    private static final String ERROR_BUILDING_IMAGE = "ImageBuildError.msg";
    private IDockerConnection connection;

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ImageBuild wizard = new ImageBuild();
        boolean buildImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (buildImage) {
            if (activePart instanceof DockerImagesView) {
                this.connection = ((DockerImagesView)activePart).getConnection();
            }
            this.performBuildImage(wizard);
        }
        return null;
    }

    private void performBuildImage(final ImageBuild wizard) {
        Job buildImageJob = new Job(DVMessages.getString(BUILD_IMAGE_JOB_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                final String id = wizard.getImageName();
                int lines = wizard.getNumberOfLines();
                IPath path = wizard.getDirectory();
                monitor.beginTask(DVMessages.getString(BuildImageCommandHandler.BUILD_IMAGE_JOB_TITLE), 1);
                try {
                    try {
                        ((DockerConnection)BuildImageCommandHandler.this.connection).buildImage(path, id, (IDockerProgressHandler)new ImageBuildProgressHandler(BuildImageCommandHandler.this.connection, id, lines));
                        monitor.worked(1);
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DVMessages.getFormattedString(BuildImageCommandHandler.ERROR_BUILDING_IMAGE, id), (String)e.getMessage());
                            }
                        });
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        buildImageJob.schedule();
    }
}

