/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class BaseContainersCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        final IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (connection == null || selectedContainers.isEmpty()) {
            return null;
        }
        Job job = new Job(this.getJobName(selectedContainers)){

            protected IStatus run(IProgressMonitor monitor) {
                if (BaseContainersCommandHandler.this.confirmed(selectedContainers)) {
                    monitor.beginTask(BaseContainersCommandHandler.this.getJobName(selectedContainers), selectedContainers.size());
                    for (IDockerContainer container : selectedContainers) {
                        monitor.setTaskName(BaseContainersCommandHandler.this.getTaskName(container));
                        BaseContainersCommandHandler.this.executeInJob(container, connection);
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    void openError(final String errorMessage, final Exception e) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)errorMessage, (String)e.getMessage());
            }
        });
    }

    boolean confirmed(List<IDockerContainer> selectedContainers) {
        return true;
    }

    abstract String getJobName(List<IDockerContainer> var1);

    abstract String getTaskName(IDockerContainer var1);

    abstract void executeInJob(IDockerContainer var1, IDockerConnection var2);
}

