/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.docker.ui.launch.IRunConsoleListener;

public class ConsoleOutputStream
extends OutputStream {
    private OutputStream stream;
    ListenerList consoleListeners;

    public ConsoleOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
        this.notifyConsoleListeners(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.notifyConsoleListeners(b, off, len);
    }

    @Override
    public void write(int arg0) throws IOException {
        byte[] b = new byte[]{(byte)arg0};
        this.write(b);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public void addConsoleListener(IRunConsoleListener listener) {
        if (this.consoleListeners == null) {
            this.consoleListeners = new ListenerList(1);
        }
        this.consoleListeners.add((Object)listener);
    }

    public void removeConsoleListener(IRunConsoleListener listener) {
        if (this.consoleListeners != null) {
            this.consoleListeners.remove((Object)listener);
        }
    }

    public void notifyConsoleListeners(byte[] b, int off, int len) {
        if (this.consoleListeners != null) {
            String output = new String(b, off, len);
            Object[] listeners = this.consoleListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IRunConsoleListener)listeners[i]).newOutput(output);
                ++i;
            }
        }
    }
}

