/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.modules;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.webtools.modules.ArchivesModelModuleContributor;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;

public class PackageModuleFactory
extends ModuleFactoryDelegate {
    public static final String FACTORY_TYPE_ID = "org.jboss.ide.eclipse.as.core.PackageModuleFactory";
    public static final String MODULE_TYPE = "jboss.package";
    public static final String VERSION = "1.0";
    public static final String MODULE_ID_PROPERTY_KEY = "org.jboss.ide.eclipse.as.core.packages.ModuleIDPropertyKey";
    private static PackageModuleFactory factDelegate;
    private static ModuleFactory factory;
    private static Random generator2;
    protected final ArchivesModelModuleContributor moduleContributor = new ArchivesModelModuleContributor(this);

    static {
        generator2 = new Random(19580499L);
    }

    public static PackageModuleFactory getFactory() {
        if (factDelegate == null) {
            ModuleFactory[] factories = ServerPlugin.getModuleFactories();
            int i = 0;
            while (i < factories.length) {
                ModuleFactoryDelegate o;
                if (factories[i].getId().equals(FACTORY_TYPE_ID) && (o = factories[i].getDelegate((IProgressMonitor)new NullProgressMonitor())) instanceof PackageModuleFactory) {
                    factory = factories[i];
                    factDelegate = (PackageModuleFactory)o;
                    return factDelegate;
                }
                ++i;
            }
        }
        return factDelegate;
    }

    protected static String getStamp(IArchive pack) {
        return PackageModuleFactory.getStamp(pack, false);
    }

    protected static String getStamp(IArchive pack, boolean create) {
        String propVal = pack.getProperty(MODULE_ID_PROPERTY_KEY);
        if (propVal == null && create) {
            propVal = "" + new Date().getTime() + System.nanoTime() + generator2.nextInt();
        }
        return propVal;
    }

    protected static String getId(IArchive pack) {
        IPath p = pack.getModelRootNode().getDescriptor().append(PackageModuleFactory.getStamp(pack));
        return p.toString();
    }

    public IModule findModule(String id) {
        IModule m = super.findModule(id);
        IModule[] allModules = this.getModules();
        int i = 0;
        while (i < allModules.length) {
            Path p = new Path(allModules[i].getId());
            if (p.lastSegment().equals(id)) {
                return allModules[i];
            }
            ++i;
        }
        return m;
    }

    public static String getProjectName(IArchiveNode node) {
        IPath projPath = node.getProjectPath();
        if (projPath == null) {
            return null;
        }
        IProject[] list = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < list.length) {
            if (list[i].getLocation().equals((Object)projPath)) {
                return list[i].getName();
            }
            ++i;
        }
        return null;
    }

    public static String getName(IArchive pack) {
        return String.valueOf(PackageModuleFactory.getProjectName((IArchiveNode)pack)) + "/" + pack.getName();
    }

    public void refreshProject(IPath projectLoc) {
        this.moduleContributor.refreshProject(projectLoc);
    }

    protected IModule createModule2(IArchive pack, IProject project) {
        return this.createModule(PackageModuleFactory.getId(pack), PackageModuleFactory.getName(pack), MODULE_TYPE, VERSION, project);
    }

    public IModule[] getModules(IProject project) {
        this.moduleContributor.refreshProject(project.getLocation());
        return super.getModules(project);
    }

    public IModule[] getModules() {
        return this.moduleContributor.getModules();
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return this.moduleContributor.getModuleDelegate(module);
    }

    public static class DelegateInitVisitor
    implements IArchiveNodeVisitor {
        private IArchive pack;
        private HashMap<IArchiveNode, IModuleResource> members;
        private HashMap<IPath, IArchiveNode> pathToNode;

        public DelegateInitVisitor(IArchive pack) {
            this.pack = pack;
            this.reset();
        }

        public void reset() {
            this.members = new HashMap();
            this.pathToNode = new HashMap();
        }

        protected boolean addZippedPackage(IArchiveNode node) {
            IPath pathWithName = node.getRootArchiveRelativePath().removeFirstSegments(1);
            IPath path = pathWithName;
            if (path.segmentCount() > 0) {
                path = path.removeLastSegments(1);
            }
            File root = ModelUtil.getBaseDestinationFile((IArchiveNode)node).toFile();
            ModuleFile mf = new ModuleFile(root, root.getName(), path);
            this.members.put(node, (IModuleResource)mf);
            this.pathToNode.put(pathWithName, node);
            if (node.getRootArchive() != node) {
                ((PackagesModuleFolder)this.members.get(node.getParent())).addChild((IModuleResource)mf);
            }
            return false;
        }

        protected boolean addFolder(IArchiveNode node) {
            IPath pathWithName = node.getRootArchiveRelativePath().removeFirstSegments(1);
            IPath path = pathWithName;
            if (path.segmentCount() > 0) {
                path = path.removeLastSegments(1);
            }
            File root = ModelUtil.getBaseDestinationFile((IArchiveNode)node).toFile();
            PackagesModuleFolder mf = new PackagesModuleFolder(root, root.getName(), path);
            this.members.put(node, (IModuleResource)mf);
            this.pathToNode.put(pathWithName, node);
            if (node.getRootArchive() != node) {
                ((PackagesModuleFolder)this.members.get(node.getParent())).addChild((IModuleResource)mf);
            }
            return true;
        }

        public boolean addFilesetAsChild(IArchiveFileSet fs) {
            DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files = fs.findMatchingPaths();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    this.addFilesetPathAsChild(fs, files[i]);
                    ++i;
                }
            }
            return true;
        }

        public void addFilesetPathAsChild(IArchiveFileSet fs, DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper file) {
            Path fsRelative = new Path(file.getFilesetRelative());
            IPath path = fs.getRootArchiveRelativePath().removeFirstSegments(1).append((IPath)fsRelative);
            PackagesModuleFolder parent = this.find(fs, fsRelative.removeLastSegments(1), true);
            ModuleFile mf = new ModuleFile((File)file, file.getName(), path.removeLastSegments(1));
            parent.addChild((IModuleResource)mf);
        }

        protected PackagesModuleFolder find(IArchiveFileSet fs, IPath fsRelative, boolean create) {
            PackagesModuleFolder folder = (PackagesModuleFolder)this.members.get(fs.getParent());
            folder.getModuleRelativePath().append(folder.getName());
            IPath tmpPath = fs.getRootArchiveRelativePath().removeFirstSegments(1);
            int count = fsRelative.segmentCount();
            int i = 0;
            while (i < count) {
                tmpPath = tmpPath.append(fsRelative.segment(i));
                PackagesModuleFolder tmpFolder = folder.getChild(fsRelative.segment(i));
                if (tmpFolder == null) {
                    if (!create) {
                        return null;
                    }
                    tmpFolder = new PackagesModuleFolder(null, tmpPath.lastSegment(), tmpPath.removeLastSegments(1));
                    folder.addChild((IModuleResource)tmpFolder);
                }
                folder = tmpFolder;
                ++i;
            }
            return folder;
        }

        public boolean visit(IArchiveNode node) {
            try {
                if (node == this.pack && !this.pack.isExploded()) {
                    return this.addZippedPackage((IArchiveNode)this.pack);
                }
                int type = node.getNodeType();
                if (type == 0 && !((IArchive)node).isExploded()) {
                    return this.addZippedPackage(node);
                }
                if (type == 0 || type == 3) {
                    return this.addFolder(node);
                }
                if (type == 2) {
                    return this.addFilesetAsChild((IArchiveFileSet)node);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        public IModuleResource getRootResource() {
            return this.members.get(this.pack);
        }

        public IModuleResource getResourceForNode(IArchiveNode node) {
            return this.members.get(node);
        }
    }

    public static class PackagedModuleDelegate
    extends ModuleDelegate
    implements IJBTModule {
        private IArchive pack;
        private IModuleResource rootResource;
        private DelegateInitVisitor initVisitor;

        public PackagedModuleDelegate(IArchive pack) {
            this.pack = pack;
            this.initVisitor = new DelegateInitVisitor(pack);
        }

        public IArchive getPackage() {
            return this.pack;
        }

        public IModule[] getChildModules() {
            return new IModule[0];
        }

        protected void init() {
            this.initVisitor.reset();
            this.pack.accept((IArchiveNodeVisitor)this.initVisitor);
            this.rootResource = this.initVisitor.getRootResource();
        }

        public IModuleResource[] members() throws CoreException {
            this.init();
            if (!this.pack.isExploded()) {
                return new IModuleResource[]{this.rootResource};
            }
            return ((IModuleFolder)this.rootResource).members();
        }

        public IStatus validate() {
            return Status.OK_STATUS;
        }

        public IModule[] getModules() {
            return new IModule[0];
        }

        public String getURI(IModule module) {
            return null;
        }

        public boolean isBinary() {
            return this.rootResource instanceof IModuleFile;
        }
    }

    public static class PackagesModuleFolder
    extends ModuleFolder {
        private File file;
        private HashMap<String, IModuleResource> children = new HashMap();

        public PackagesModuleFolder(File f, String name, IPath path) {
            super(null, name, path);
            this.file = f;
        }

        public Object getAdapter(Class cl) {
            if (File.class.equals((Object)cl)) {
                return this.file;
            }
            return null;
        }

        public void addChild(IModuleResource resource) {
            this.children.put(resource.getName(), resource);
            Collection<IModuleResource> l = this.children.values();
            this.setMembers(l.toArray(new IModuleResource[l.size()]));
        }

        public PackagesModuleFolder getChild(String name) {
            IModuleResource o = this.children.get(name);
            if (o != null && o instanceof PackagesModuleFolder) {
                return (PackagesModuleFolder)o;
            }
            return null;
        }
    }
}

