/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedMemberFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSeverityPreferences;
import org.jboss.tools.cdi.deltaspike.core.validation.DeltaspikeValidationMessages;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeanMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.impl.AnnotationLiteral;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;

public class DeltaspikeExceptionExtension
implements ICDIExtension,
IProcessAnnotatedMemberFeature,
IValidatorFeature,
DeltaspikeConstants {
    public void processAnnotatedMember(BeanMemberDefinition memberDefinition, IRootDefinitionContext context) {
        IJavaAnnotation ja;
        ParameterDefinition p;
        if (memberDefinition instanceof ParameterDefinition && this.isHandler((IAnnotated)(p = (ParameterDefinition)memberDefinition)) && (ja = this.createFakeObservesAnnotation((AbstractMemberDefinition)memberDefinition, context)) != null) {
            p.addAnnotation(ja, context);
        }
    }

    private boolean isHandler(IAnnotated p) {
        return p.isAnnotationPresent("org.apache.deltaspike.core.api.exception.control.Handles") || p.isAnnotationPresent("org.apache.deltaspike.core.api.exception.control.BeforeHandles");
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        ICDIProject cdi = CDICorePlugin.getCDIProject((IProject)file.getProject(), (boolean)true);
        for (IBean b : cdi.getBeans(file.getFullPath())) {
            if (!(b instanceof IClassBean)) continue;
            IClassBean cb = (IClassBean)b;
            boolean isExceptionHandler = cb.isAnnotationPresent("org.apache.deltaspike.core.api.exception.control.ExceptionHandler");
            for (IBeanMethod m : cb.getAllMethods()) {
                for (IParameter p : m.getParameters()) {
                    IType t;
                    if (!this.isHandler((IAnnotated)p)) continue;
                    if (!isExceptionHandler) {
                        IAnnotationDeclaration s = p.getAnnotation("org.apache.deltaspike.core.api.exception.control.Handles");
                        if (s == null) {
                            s = p.getAnnotation("org.apache.deltaspike.core.api.exception.control.BeforeHandles");
                        }
                        if (s == null) {
                            s = p;
                        }
                        validator.addError(DeltaspikeValidationMessages.NOT_A_HANDLER_BEAN, DeltaspikeSeverityPreferences.NOT_A_HANDLER_BEAN, new String[0], (ITextSourceReference)s, (IResource)file);
                    }
                    if ((t = p.getType().getType()) == null || "org.apache.deltaspike.core.api.exception.control.event.ExceptionEvent".equals(t.getFullyQualifiedName())) continue;
                    validator.addError(DeltaspikeValidationMessages.INVALID_HANDLER_TYPE, DeltaspikeSeverityPreferences.INVALID_HANDLER_TYPE, new String[0], (ITextSourceReference)p, (IResource)file);
                }
            }
        }
    }

    IJavaAnnotation createFakeObservesAnnotation(AbstractMemberDefinition def, IRootDefinitionContext context) {
        IType producesAnnotation;
        AnnotationLiteral result = null;
        AnnotationDeclaration a = def.getAnnotation("org.apache.deltaspike.core.api.exception.control.Handles");
        if (a == null) {
            a = def.getAnnotation("org.apache.deltaspike.core.api.exception.control.BeforeHandles");
        }
        if (a != null && (producesAnnotation = context.getProject().getType("javax.enterprise.event.Observes")) != null) {
            AnnotationLiteral literal = new AnnotationLiteral(def.getResource(), a.getStartPosition(), a.getLength(), null, 14, producesAnnotation);
            literal.setParentElement((IJavaElement)def.getMember());
            result = literal;
        }
        return result;
    }

    public SeverityPreferences getSeverityPreferences() {
        return DeltaspikeSeverityPreferences.getInstance();
    }
}

