/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.validate.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.core.validate.IFileNameValidator;
import org.jboss.tools.foundation.core.validate.impl.FileNameValidatorConstants;
import org.jboss.tools.foundation.core.validate.impl.Messages;

public class FileNameValidator
implements IFileNameValidator,
FileNameValidatorConstants {
    private static final String WINDOWS = "WINDOWS";
    private static final String MAC = "MAC";
    private String parentDir = System.getProperty("java.io.tmpdir");
    private Collection<Character> reservedChars = new ArrayList<Character>();
    private Collection<String> reservedWords = new ArrayList<String>();

    private boolean isFailure(IStatus status) {
        return status.matches(4);
    }

    private IStatus createFailureStatus(String message) {
        return new Status(4, "org.jboss.tools.foundation.core", message);
    }

    private IStatus createWarningStatus(String message) {
        return new Status(2, "org.jboss.tools.foundation.core", message);
    }

    private boolean isWindows() {
        return this.getOSValue().contains(WINDOWS);
    }

    private boolean isMac() {
        return this.getOSValue().contains(MAC);
    }

    private String getOSValue() {
        return System.getProperty("os.name").toUpperCase();
    }

    private boolean shouldCreateTestFile(int systems) {
        return this.failLocalFilesystem(systems) || this.isWindows() && this.failWindows(systems) || this.isMac() && this.failMac(systems);
    }

    private boolean failLocalFilesystem(int systems) {
        return (systems & 1) == 1;
    }

    private boolean failWindows(int systems) {
        return this.isWindows() && (systems & 1) == 1 || (systems & 2) == 2;
    }

    private boolean failMac(int systems) {
        return this.isMac() && (systems & 1) == 1 || (systems & 4) == 4;
    }

    private IStatus testNullCharacter(String fileName) {
        if (fileName.contains("\u0000")) {
            return this.createFailureStatus(Messages.FileNameValidatorNullCharacter);
        }
        return Status.OK_STATUS;
    }

    private IStatus testLength(String fileName) {
        if (fileName.length() > 255) {
            return this.createFailureStatus(Messages.FileNameValidatorTooLong);
        }
        return Status.OK_STATUS;
    }

    private IStatus testReservedChars(String fileName, int systems) {
        char c;
        for (char c2 : this.reservedChars) {
            if (fileName.indexOf(c2) <= -1) continue;
            return this.createFailureStatus(Messages.FileNameValidatorReservedCharacter);
        }
        char[] cArray = RESERVED_CHARACTERS;
        int n = RESERVED_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c2;
            c2 = cArray[n2];
            if (fileName.indexOf(c2) > -1) {
                return this.createFailureStatus(Messages.FileNameValidatorReservedCharacter);
            }
            ++n2;
        }
        MultiStatus status = new MultiStatus("org.jboss.tools.foundation.core", 0, "", null);
        char[] cArray2 = MAC_RESERVED_CHARACTERS;
        int n3 = MAC_RESERVED_CHARACTERS.length;
        n = 0;
        while (n < n3) {
            c = cArray2[n];
            if (fileName.indexOf(c) > -1) {
                if (this.failMac(systems)) {
                    return this.createFailureStatus(Messages.FileNameValidatorReservedCharacter);
                }
                status.add(this.createWarningStatus(Messages.FileNameValidatorReservedCharacter));
            }
            ++n;
        }
        cArray2 = WIN_RESERVED_CHARACTERS;
        n3 = WIN_RESERVED_CHARACTERS.length;
        n = 0;
        while (n < n3) {
            c = cArray2[n];
            if (fileName.indexOf(c) > -1) {
                if (this.failWindows(systems)) {
                    return this.createFailureStatus(Messages.FileNameValidatorReservedCharacter);
                }
                status.add(this.createWarningStatus(Messages.FileNameValidatorReservedCharacter));
            }
            ++n;
        }
        return status;
    }

    private IStatus testReservedWord(String fileName, int systems) {
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot > -1) {
            fileName = fileName.substring(0, lastDot);
        }
        for (String word : this.reservedWords) {
            if (!word.equalsIgnoreCase(fileName)) continue;
            return this.createFailureStatus(Messages.FileNameValidatorReservedWord);
        }
        String[] stringArray = RESERVED_WORDS;
        int n = RESERVED_WORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word;
            word = stringArray[n2];
            if (word.equalsIgnoreCase(fileName)) {
                return this.createFailureStatus(Messages.FileNameValidatorReservedWord);
            }
            ++n2;
        }
        MultiStatus status = new MultiStatus("org.jboss.tools.foundation.core", 0, "", null);
        String[] stringArray2 = WIN_RESERVED_WORDS;
        int n3 = WIN_RESERVED_WORDS.length;
        n = 0;
        while (n < n3) {
            String word = stringArray2[n];
            if (word.equalsIgnoreCase(fileName)) {
                if (this.failWindows(systems)) {
                    return this.createFailureStatus(Messages.FileNameValidatorReservedWord);
                }
                status.add(this.createWarningStatus(Messages.FileNameValidatorReservedWord));
            }
            ++n;
        }
        return status;
    }

    private IStatus testSuffix(String fileName, int systems) {
        int dotIndex = fileName.indexOf(".");
        if (dotIndex < 1 || dotIndex >= fileName.length() - 1) {
            if (this.failWindows(systems)) {
                return this.createFailureStatus(Messages.FileNameValidatorNoSuffix);
            }
            return this.createWarningStatus(Messages.FileNameValidatorNoSuffix);
        }
        return Status.OK_STATUS;
    }

    private IStatus testIllegalFinalCharacter(String fileName, int systems) {
        if (fileName.endsWith(".") || fileName.endsWith(" ")) {
            if (this.failWindows(systems)) {
                return this.createFailureStatus(Messages.FileNameValidatorEndsFinalCharacter);
            }
            return this.createWarningStatus(Messages.FileNameValidatorEndsFinalCharacter);
        }
        return Status.OK_STATUS;
    }

    private void evaluate(IStatus testStatus, ValidatorStatus outputStatus) {
        if (!testStatus.isOK()) {
            outputStatus.add(testStatus);
            switch (outputStatus.getSeverity()) {
                case 4: {
                    outputStatus.setMessage(Messages.FileNameValidatorValidationFailed);
                    break;
                }
                case 2: {
                    outputStatus.setMessage(Messages.FileNameValidatorValidationWarning);
                }
            }
        }
    }

    @Override
    public IStatus validate(String fileName) {
        return this.validate(fileName, 1);
    }

    @Override
    public IStatus validate(String fileName, int systems) {
        if (fileName == null) {
            return this.createFailureStatus(Messages.FileNameValidatorNullFileName);
        }
        ValidatorStatus resultStatus = new ValidatorStatus();
        this.evaluate(this.testLength(fileName), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        this.evaluate(this.testNullCharacter(fileName), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        this.evaluate(this.testIllegalFinalCharacter(fileName, systems), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        this.evaluate(this.testReservedChars(fileName, systems), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        this.evaluate(this.testReservedWord(fileName, systems), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        this.evaluate(this.testSuffix(fileName, systems), resultStatus);
        if (this.isFailure((IStatus)resultStatus)) {
            return resultStatus;
        }
        if (this.shouldCreateTestFile(systems)) {
            File tempTestFile = new File(this.parentDir, fileName);
            try {
                if (tempTestFile.createNewFile()) {
                    tempTestFile.delete();
                } else {
                    resultStatus.add(this.createFailureStatus(Messages.FileNameValidatorFailedToCreateTestFile));
                }
            }
            catch (Exception ex) {
                StringBuilder builder = new StringBuilder(Messages.FileNameValidatorFailedToCreateTestFile);
                builder.append("\n");
                builder.append(ex.getLocalizedMessage());
                resultStatus.add(this.createFailureStatus(builder.toString()));
            }
        }
        return resultStatus;
    }

    @Override
    public void setParentDirectory(String directory) {
        this.parentDir = directory;
    }

    @Override
    public void addReservedCharacter(Character character) {
        this.reservedChars.add(character);
    }

    @Override
    public void addReservedWord(String reservedWord) {
        this.reservedWords.add(reservedWord);
    }

    private class ValidatorStatus
    extends MultiStatus {
        public ValidatorStatus() {
            super("org.jboss.tools.foundation.core", 0, Messages.FileNameValidatorValidationSuccessful, null);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

