/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.properties.internal;

import java.util.Arrays;

public class SimpleHierarchicalVersion {
    private String internalVersion;

    public SimpleHierarchicalVersion(String version) {
        this.internalVersion = version;
    }

    public SimpleHierarchicalVersion getParentVersion() {
        String parentVersion = SimpleHierarchicalVersion.getOneVersionUp(this.internalVersion);
        if (parentVersion == null || this.internalVersion.equals(parentVersion)) {
            return null;
        }
        return new SimpleHierarchicalVersion(parentVersion);
    }

    static String getOneVersionUp(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.lastIndexOf("-SNAPSHOT"));
        }
        String[] segments = version.split("\\.");
        int newLength = 0;
        int curLength = segments.length;
        if (curLength > 3) {
            String qualifier = segments[3];
            int dashIndex = qualifier.indexOf(45);
            if (dashIndex > 0) {
                segments[3] = qualifier.substring(0, dashIndex);
                newLength = 4;
            } else {
                newLength = curLength > 4 ? 4 : 3;
            }
        } else {
            newLength = segments.length - 1;
        }
        if (newLength > 0) {
            return SimpleHierarchicalVersion.join(Arrays.copyOf(segments, newLength));
        }
        return null;
    }

    public String toString() {
        return this.internalVersion;
    }

    private static String join(String ... segments) {
        if (segments.length == 0) {
            return null;
        }
        if (segments.length == 1) {
            return segments[0];
        }
        boolean addSeparator = false;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (addSeparator) {
                sb.append('.');
            }
            sb.append(s);
            addSeparator = true;
            ++n2;
        }
        return sb.toString();
    }
}

