/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.ecf.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.foundation.core.digest.DigestUtils;
import org.jboss.tools.foundation.core.ecf.Messages;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.internal.FoundationCorePlugin;
import org.jboss.tools.foundation.core.internal.Trace;

public class URLTransportCache {
    private static final String ENCODING = "UTF-8";
    private static final String LOCAL_CACHE_LOCATION_FOLDER = "ECF_REMOTE_CACHE";
    private static final String CACHE_MAP_KEY = "URLTransportCache.CacheMapKey";
    private static final String CACHE_INDEX_FILE = "URLTransportCache.cacheIndex.properties";
    private static final IPath DEFAULT_CACHE_FOLDER = FoundationCorePlugin.getDefault().getStateLocation().append("ECF_REMOTE_CACHE");
    private static final HashMap<IPath, URLTransportCache> cacheDirToCache = new HashMap();
    private HashMap<String, String> cache;
    private IPath cacheRoot;

    public static synchronized URLTransportCache getDefault() {
        return URLTransportCache.getCache(DEFAULT_CACHE_FOLDER);
    }

    public static synchronized URLTransportCache getCache(IPath root) {
        URLTransportCache c = cacheDirToCache.get(root);
        if (c == null) {
            c = new URLTransportCache(root);
            cacheDirToCache.put(root, c);
        }
        return c;
    }

    protected URLTransportCache(IPath cacheRoot) {
        this.cacheRoot = cacheRoot;
        this.cache = new HashMap();
        this.load();
    }

    public File getCachedFile(String url) {
        String cacheVal = this.cache.get(url);
        if (cacheVal == null) {
            return null;
        }
        File f = new File(cacheVal);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public boolean isCacheOutdated(String url, IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", "Checking if cache is outdated for " + url);
        File f = this.getCachedFile(url);
        if (f == null) {
            return true;
        }
        URL url2 = null;
        try {
            url2 = new URL(url);
        }
        catch (MalformedURLException murle) {
            throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(Messages.ECFExamplesTransport_IO_error, murle));
        }
        long remoteModified = new URLTransportUtility().getLastModified(url2, monitor);
        if (remoteModified == -1L && f.exists()) {
            return false;
        }
        if (f.exists()) {
            long modified = f.lastModified();
            if (remoteModified > modified) {
                return true;
            }
            return remoteModified == 0L;
        }
        return true;
    }

    public File downloadAndCache(String url, String displayName, int lifespan, URLTransportUtility util, IProgressMonitor monitor) throws CoreException {
        return this.downloadAndCache(url, displayName, lifespan, util, -1, monitor);
    }

    public File downloadAndCache(String url, String displayName, int lifespan, URLTransportUtility util, int timeout, IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", "Downloading and caching " + url + " with lifespan=" + lifespan);
        File existing = this.getExistingRemoteFileCacheLocation(url);
        File target = this.createNewRemoteFileCacheLocation(url);
        try {
            FileOutputStream os = new FileOutputStream(target);
            IStatus s = util.download(displayName, url, os, timeout, monitor);
            if (s.isOK()) {
                if (lifespan == 2) {
                    target.deleteOnExit();
                }
                this.addToCache(url, target);
                if (existing != null && existing.exists()) {
                    existing.delete();
                }
                return target != null && target.exists() ? target : null;
            }
            if (target != null && target.exists()) {
                target.delete();
            }
            return existing;
        }
        catch (IOException ioe) {
            throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(Messages.ECFExamplesTransport_IO_error, ioe));
        }
    }

    private void addToCache(String url, File target) {
        this.cache.put(url, target.getAbsolutePath());
        this.savePreferences();
    }

    private void load() {
        File index;
        if (this.cacheRoot.equals((Object)DEFAULT_CACHE_FOLDER)) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.foundation.core");
            String val = prefs.get(CACHE_MAP_KEY, "");
            this.loadIndexFromString(val);
        }
        if ((index = this.cacheRoot.append(CACHE_INDEX_FILE).toFile()).exists() && index.isFile()) {
            try {
                String contents = URLTransportCache.getContents(index);
                this.loadIndexFromString(contents);
            }
            catch (IOException ioe) {
                FoundationCorePlugin.pluginLog().logError(ioe);
            }
        }
        Trace.trace("/finer", "Loaded " + this.cache.size() + " cache file locations from preferences");
    }

    private void loadIndexFromString(String val) {
        if (!this.isEmpty(val)) {
            String[] byLine = val.split("\n");
            int i = 0;
            while (i < byLine.length) {
                String[] kv;
                if (!(this.isEmpty(byLine[i]) || (kv = byLine[i].split("=")).length != 2 || this.isEmpty(kv[0]) || this.isEmpty(kv[1]))) {
                    try {
                        String decodedUrl = URLDecoder.decode(kv[0], ENCODING);
                        if (new File(kv[1]).exists()) {
                            this.cache.put(decodedUrl, kv[1]);
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        FoundationCorePlugin.pluginLog().logError(uee);
                    }
                }
                ++i;
            }
        }
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    private void savePreferences() {
        File index = this.cacheRoot.append(CACHE_INDEX_FILE).toFile();
        Trace.trace("/finer", "Saving " + this.cache.size() + " cache file locations to " + index.getAbsolutePath());
        StringBuffer sb = new StringBuffer();
        for (String k : this.cache.keySet()) {
            String v = this.cache.get(k);
            String encodedURL = null;
            try {
                encodedURL = URLEncoder.encode(k, ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (encodedURL == null) continue;
            sb.append(String.valueOf(encodedURL) + "=" + v + "\n");
        }
        try {
            URLTransportCache.setContents(index, sb.toString());
        }
        catch (IOException e) {
            FoundationCorePlugin.pluginLog().logError(e);
        }
    }

    private synchronized File getExistingRemoteFileCacheLocation(String url) {
        String cachedLoc = this.cache.get(url);
        if (cachedLoc != null) {
            File f = new File(this.cache.get(url));
            return f;
        }
        return null;
    }

    private synchronized File getRemoteFileCacheLocation(String url) {
        File existing = this.getExistingRemoteFileCacheLocation(url);
        if (existing != null) {
            return existing;
        }
        return this.createNewRemoteFileCacheLocation(url);
    }

    private synchronized File createNewRemoteFileCacheLocation(String url) {
        String tmp;
        File root = this.getLocalCacheFolder().toFile();
        root.mkdirs();
        try {
            tmp = DigestUtils.sha1(url);
        }
        catch (IOException iOException) {
            tmp = url.replaceAll("[\\p{Punct}&&[^_]]", "_");
        }
        File cached = null;
        while ((cached = new File(root, String.valueOf(tmp) + new SecureRandom().nextLong() + ".tmp")).exists()) {
        }
        return cached;
    }

    private IPath getLocalCacheFolder() {
        return this.cacheRoot;
    }

    private static String getContents(File aFile) throws IOException {
        return new String(URLTransportCache.getBytesFromFile(aFile), ENCODING);
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] bytes = new byte[(int)file.length()];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    private static void setContents(File file, String contents) throws IOException {
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
            out.append(contents);
        }
    }
}

