/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.digest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private DigestUtils() {
    }

    public static String sha1(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return DigestUtils.sha1(file.toPath());
    }

    public static String sha1(Path pathToFile) throws IOException {
        if (pathToFile != null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream input = Files.newInputStream(pathToFile, new OpenOption[0]);){
                return DigestUtils.sha1(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    public static String sha1(String text) throws IOException {
        if (text == null) {
            return null;
        }
        return DigestUtils.sha1(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha1(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] bytes = new byte[16384];
            int count = 0;
            while ((count = input.read(bytes)) != -1) {
                md.update(bytes, 0, count);
            }
            byte[] digestBytes = md.digest();
            int i = 0;
            while (i < digestBytes.length) {
                sb.append(Integer.toString((digestBytes[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return sb.toString();
    }
}

