/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tern.TernException;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcess;
import tern.server.nodejs.process.NodejsProcessAdapter;

public class NodejsProcessManager {
    private static final NodejsProcessManager INSTANCE = new NodejsProcessManager();
    private final List<NodejsProcess> processes;
    private File nodejsTernBaseDir;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStart(NodejsProcess server) {
            List list = NodejsProcessManager.this.processes;
            synchronized (list) {
                NodejsProcessManager.this.processes.add(server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStop(NodejsProcess server) {
            List list = NodejsProcessManager.this.processes;
            synchronized (list) {
                NodejsProcessManager.this.processes.remove(server);
            }
        }
    };

    public static NodejsProcessManager getInstance() {
        return INSTANCE;
    }

    public NodejsProcessManager() {
        this.processes = new ArrayList<NodejsProcess>();
    }

    public NodejsProcess create(File projectDir) throws TernException {
        return this.create(projectDir, null, this.nodejsTernBaseDir);
    }

    public NodejsProcess create(File projectDir, File nodejsBaseDir) throws TernException {
        return this.create(projectDir, nodejsBaseDir, this.nodejsTernBaseDir);
    }

    public NodejsProcess create(File projectDir, File nodejsBaseDir, File nodejsTernBaseDir) throws TernException {
        NodejsProcess process = new NodejsProcess(nodejsBaseDir, nodejsTernBaseDir, projectDir);
        process.addProcessListener(this.listener);
        return process;
    }

    public void init(File nodejsTernBaseDir) {
        this.nodejsTernBaseDir = nodejsTernBaseDir;
    }

    public File getNodejsTernBaseDir() {
        return this.nodejsTernBaseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<NodejsProcess> list = this.processes;
        synchronized (list) {
            for (NodejsProcess server : this.processes) {
                try {
                    server.kill();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.processes.clear();
        }
    }
}

