/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import tern.TernException;
import tern.server.nodejs.NodejsTernHelper;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcessException;

public class NodejsProcess {
    private final File nodejsBaseDir;
    private final File nodejsTernFile;
    private final File projectDir;
    private Integer port;
    private long elapsedSartTime = 0L;
    private boolean verbose;
    private boolean noPortFile;
    private boolean persistent;
    private boolean loadingLocalPlugins;
    private Process process;
    private Thread outThread;
    private Thread errThread;
    private final List<INodejsProcessListener> listeners;
    private final Object lock = new Object();
    private boolean hasError;

    NodejsProcess(File nodejsTernBaseDir, File projectDir) throws TernException {
        this(null, nodejsTernBaseDir, projectDir);
    }

    NodejsProcess(File nodejsBaseDir, File nodejsTernBaseDir, File projectDir) throws TernException {
        this.nodejsBaseDir = nodejsBaseDir;
        this.nodejsTernFile = this.getNodejsTernFile(nodejsTernBaseDir);
        this.projectDir = projectDir;
        this.listeners = new ArrayList<INodejsProcessListener>();
        this.hasError = false;
        this.setNoPortFile(true);
    }

    private File getNodejsTernFile(File nodejsTernBaseDir) throws TernException {
        if (nodejsTernBaseDir == null) {
            throw new TernException("You must initialize the base dir of the tern node.js server.");
        }
        File ternServerFile = new File(nodejsTernBaseDir, "bin/tern");
        if (!ternServerFile.exists()) {
            try {
                throw new TernException("Cannot find tern node.js server at " + ternServerFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                throw new TernException("Cannot find tern node.js server at " + ternServerFile.getPath());
            }
        }
        return ternServerFile;
    }

    protected List<String> createCommands() {
        LinkedList<String> commands = new LinkedList<String>();
        if (this.nodejsBaseDir == null) {
            if (new File("/usr/local/bin/node").exists()) {
                commands.add("/usr/local/bin/node");
            }
            if (new File("/opt/local/bin/node").exists()) {
                commands.add("/opt/local/bin/node");
            } else {
                commands.add("node");
            }
        } else {
            commands.add(this.nodejsBaseDir.getPath());
        }
        try {
            commands.add(this.nodejsTernFile.getCanonicalPath());
        }
        catch (IOException iOException) {
            commands.add(this.nodejsTernFile.getPath());
        }
        Integer port = this.getPort();
        if (port != null) {
            commands.add("--port");
            commands.add(port.toString());
        }
        if (this.isVerbose()) {
            commands.add("--verbose");
            commands.add("1");
        }
        if (this.isNoPortFile()) {
            commands.add("--no-port-file");
        }
        if (this.isPersistent()) {
            commands.add("--persistent");
        }
        if (!this.isLoadingLocalPlugins()) {
            commands.add("--disable-loading-local");
        }
        return commands;
    }

    public void start() throws NodejsProcessException {
        if (this.isStarted()) {
            this.notifyErrorProcess("Nodejs tern Server is already started.");
            throw new NodejsProcessException("Nodejs tern Server is already started.");
        }
        try {
            List<String> commands = this.createCommands();
            ProcessBuilder builder = new ProcessBuilder(commands);
            builder.directory(this.getProjectDir());
            this.notifyCreateProcess(commands, this.projectDir);
            this.process = builder.start();
            this.outThread = new Thread(new StdOut());
            this.outThread.setDaemon(true);
            this.outThread.start();
            this.errThread = new Thread(new StdErr());
            this.errThread.setDaemon(true);
            this.errThread.start();
        }
        catch (Throwable e) {
            this.notifyErrorProcess(e.getMessage());
            this.notifyErrorProcess("");
            throw new NodejsProcessException(e);
        }
    }

    public int start(long timeout, int testNumber) throws NodejsProcessException, InterruptedException {
        if (!this.isStarted()) {
            this.start();
        }
        this.waitOnStartNodejs(timeout, testNumber);
        return this.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnStartNodejs(long timeout, int testNumber) throws InterruptedException, NodejsProcessException {
        if (this.port == null) {
            if (!this.hasError) {
                int i = 0;
                while (i < testNumber) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(timeout);
                        if (this.port != null || this.hasError) {
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (this.port == null) {
                throw new NodejsProcessException("Cannot start node process.");
            }
        }
    }

    public boolean isStarted() {
        return this.process != null;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.outThread != null) {
            this.outThread.interrupt();
            this.outThread = null;
        }
        if (this.errThread != null) {
            this.errThread.interrupt();
            this.errThread = null;
        }
    }

    public Integer getPort() {
        return this.port;
    }

    void setPort(Integer port) {
        this.port = port;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setNoPortFile(boolean noPortFile) {
        this.noPortFile = noPortFile;
    }

    public boolean isNoPortFile() {
        return this.noPortFile;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setLoadingLocalPlugins(boolean loadingLocalPlugins) {
        this.loadingLocalPlugins = loadingLocalPlugins;
    }

    public boolean isLoadingLocalPlugins() {
        return this.loadingLocalPlugins;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public long getElapsedStartTime() {
        return this.elapsedSartTime;
    }

    public void join() throws InterruptedException {
        if (this.outThread != null) {
            this.outThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCreateProcess(List<String> commands, File projectDir) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onCreate(this, commands, projectDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartProcess(long startTime) {
        this.elapsedSartTime = NodejsTernHelper.getElapsedTimeInMs(startTime);
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStopProcess() {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataProcess(String line) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onData(this, line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyErrorProcess(String line) {
        this.hasError = true;
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onError(this, line);
            }
        }
    }

    private class StdErr
    implements Runnable {
        private StdErr() {
        }

        @Override
        public void run() {
            String line = null;
            InputStream is = NodejsProcess.this.process.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                while ((line = br.readLine()) != null) {
                    NodejsProcess.this.notifyErrorProcess(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class StdOut
    implements Runnable {
        private StdOut() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.nanoTime();
                Integer port = null;
                String line = null;
                InputStream is = NodejsProcess.this.process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                try {
                    while ((line = br.readLine()) != null) {
                        if (port == null) {
                            if (!line.startsWith("Listening on port ")) continue;
                            port = Integer.parseInt(line.substring("Listening on port ".length(), line.length()));
                            NodejsProcess.this.setPort(port);
                            Object object = NodejsProcess.this.lock;
                            synchronized (object) {
                                NodejsProcess.this.lock.notifyAll();
                            }
                            NodejsProcess.this.notifyStartProcess(startTime);
                            continue;
                        }
                        NodejsProcess.this.notifyDataProcess(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (NodejsProcess.this.process != null) {
                    NodejsProcess.this.process.waitFor();
                }
                NodejsProcess.this.notifyStopProcess();
                NodejsProcess.this.kill();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

