/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.npm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import tern.TernException;
import tern.server.ITernModule;
import tern.server.nodejs.npm.INPMProcessListener;
import tern.server.nodejs.process.NodejsProcessException;

public class NPMProcess {
    private final String npmPath;
    private final File projectDir;
    private Process process;
    private Thread outThread;
    private Thread errThread;
    private boolean hasError;
    private final List<INPMProcessListener> listeners;

    public NPMProcess(String npmPath, File projectDir) throws TernException {
        this.npmPath = npmPath;
        this.projectDir = projectDir;
        this.listeners = new ArrayList<INPMProcessListener>();
        this.hasError = false;
    }

    public void install(ITernModule module) throws NodejsProcessException {
        if (this.isStarted()) {
            this.notifyErrorProcess("Nodejs tern Server is already started.");
            throw new NodejsProcessException("Nodejs tern Server is already started.");
        }
        try {
            List<String> commands = this.createCommands(module);
            ProcessBuilder builder = new ProcessBuilder(commands);
            builder.directory(this.getProjectDir());
            this.notifyCreateProcess(commands, this.projectDir);
            this.process = builder.start();
            this.outThread = new Thread(new StdOut());
            this.outThread.setDaemon(true);
            this.outThread.start();
            this.errThread = new Thread(new StdErr());
            this.errThread.setDaemon(true);
            this.errThread.start();
        }
        catch (Throwable e) {
            this.notifyErrorProcess(e.getMessage());
            this.notifyErrorProcess("");
            throw new NodejsProcessException(e);
        }
    }

    private List<String> createCommands(ITernModule module) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.npmPath);
        cmds.add("install");
        cmds.add("tern-" + module.getName());
        return cmds;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean isStarted() {
        return this.process != null;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.outThread != null) {
            this.outThread.interrupt();
            this.outThread = null;
        }
        if (this.errThread != null) {
            this.errThread.interrupt();
            this.errThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(INPMProcessListener listener) {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(INPMProcessListener listener) {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCreateProcess(List<String> commands, File projectDir) {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            for (INPMProcessListener listener : this.listeners) {
                listener.onCreate(this, commands, projectDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartProcess(long startTime) {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            for (INPMProcessListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStopProcess() {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            for (INPMProcessListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataProcess(String line) {
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            for (INPMProcessListener listener : this.listeners) {
                listener.onData(this, line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyErrorProcess(String line) {
        this.hasError = true;
        List<INPMProcessListener> list = this.listeners;
        synchronized (list) {
            for (INPMProcessListener listener : this.listeners) {
                listener.onError(this, line);
            }
        }
    }

    private class StdErr
    implements Runnable {
        private StdErr() {
        }

        @Override
        public void run() {
            String line = null;
            InputStream is = NPMProcess.this.process.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                while ((line = br.readLine()) != null) {
                    NPMProcess.this.notifyErrorProcess(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class StdOut
    implements Runnable {
        private StdOut() {
        }

        @Override
        public void run() {
            try {
                System.nanoTime();
                String line = null;
                InputStream is = NPMProcess.this.process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                try {
                    while ((line = br.readLine()) != null) {
                        NPMProcess.this.notifyDataProcess(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (NPMProcess.this.process != null) {
                    NPMProcess.this.process.waitFor();
                }
                NPMProcess.this.notifyStopProcess();
                NPMProcess.this.kill();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

