/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.project.facet;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.IJBossWebUtil;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.JBossWebUtil;
import org.jboss.tools.portlet.core.JBossWebUtil25;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.internal.util.PortletUtil;
import org.jboss.tools.portlet.core.libprov.AbstractLibraryProviderInstallOperationConfig;
import org.jboss.tools.portlet.core.libprov.JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPostInstallListener
implements IFacetedProjectListener {
    private static final String JAR = ".jar";
    private static final String SOURCES_JAR = "sources.jar";
    private static final String JST_SEAM_FACET = "jst.seam";
    private static final IProjectFacet seamFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
    private static final IOverwriteQuery OVERWRITE_NONE_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "NOALL";
        }
    };
    private String portletbridgeRuntime;
    private boolean richfacesCapabilities = false;
    private boolean isEPP = false;
    private String richfacesType;
    private String richfacesRuntime;

    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent actionEvent;
        IProjectFacet projectFacet;
        if (event instanceof IProjectFacetActionEvent && !"jboss.jsfportlet".equals((projectFacet = (actionEvent = (IProjectFacetActionEvent)event).getProjectFacet()).getId())) {
            return;
        }
        IFacetedProject facetedProject = event.getProject();
        Set projectFacets = facetedProject.getProjectFacets();
        boolean isJSFPortlet = false;
        boolean richfacesFromServerRuntime = false;
        for (IProjectFacetVersion projectFacetVersion : projectFacets) {
            IProjectFacet projectFacet2 = projectFacetVersion.getProjectFacet();
            if (!"jboss.jsfportlet".equals(projectFacet2.getId())) continue;
            isJSFPortlet = true;
        }
        if (!isJSFPortlet) {
            return;
        }
        if (isJSFPortlet) {
            IProjectFacetActionEvent actionEvent2 = (IProjectFacetActionEvent)event;
            IDataModel dataModel = (IDataModel)actionEvent2.getActionConfig();
            try {
                LibraryInstallDelegate libraryDelegate = (LibraryInstallDelegate)dataModel.getProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE");
                if (libraryDelegate != null) {
                    AbstractLibraryProviderInstallOperationConfig libraryConfig;
                    ILibraryProvider libraryProvider = libraryDelegate.getLibraryProvider();
                    String providerId = libraryProvider.getId();
                    if ("jsfportletbridge-library-provider".equals(providerId)) {
                        libraryConfig = (JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig)libraryDelegate.getLibraryProviderOperationConfig(libraryProvider);
                        this.portletbridgeRuntime = ((JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig)libraryConfig).getPortletbridgeHome();
                    } else {
                        this.portletbridgeRuntime = null;
                    }
                    richfacesFromServerRuntime = "jsfportlet-library-provider".equals(providerId);
                    if ("jsfportletbridge-library-provider".equals(providerId) || "jsfportlet-library-provider".equals(providerId)) {
                        libraryConfig = (AbstractLibraryProviderInstallOperationConfig)libraryDelegate.getLibraryProviderOperationConfig(libraryProvider);
                        this.richfacesCapabilities = libraryConfig.isAddRichfacesCapabilities();
                        this.isEPP = libraryConfig.isEPP();
                        this.richfacesRuntime = libraryConfig.getRichfacesRuntime();
                        this.richfacesType = libraryConfig.getRichfacesType();
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (isJSFPortlet) {
            if (this.portletbridgeRuntime != null || this.isEPP) {
                this.addLibrariesFromPortletBridgeRuntime(facetedProject, this.portletbridgeRuntime, this.richfacesCapabilities);
            } else if (richfacesFromServerRuntime) {
                this.addLibrariesFromServerRuntime(facetedProject);
            }
            this.configureWebApp(facetedProject.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void configureWebApp(final IProject project, final IProgressMonitor monitor) {
        final IModelProvider provider = PortletCoreActivator.getModelProvider(project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (PortletCoreActivator.isWebApp25(provider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        provider.modify(new Runnable(){

            public void run() {
                IJBossWebUtil util = null;
                util = PortletCoreActivator.isWebApp25(provider.getModelObject()) ? new JBossWebUtil25() : new JBossWebUtil();
                if (PortletPostInstallListener.this.addRichfacesLibraries(project)) {
                    String name = "org.ajax4jsf.VIEW_HANDLERS";
                    String value = "org.jboss.portletbridge.application.FaceletPortletViewHandler";
                    String description = null;
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "javax.portlet.faces.renderPolicy";
                    value = "ALWAYS_DELEGATE";
                    util.configureContextParam(project, monitor, name, value, description);
                    int portletBridgeVersion = PortletUtil.getPortletBridgeVersion(project);
                    value = portletBridgeVersion <= 1 ? "NONE" : "ALL";
                    name = "org.richfaces.LoadStyleStrategy";
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "org.richfaces.LoadScriptStrategy";
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "org.ajax4jsf.RESOURCE_URI_PREFIX";
                    value = "rfRes";
                    util.configureContextParam(project, monitor, name, value, description);
                    String displayName = "Ajax4jsf Filter";
                    String filterName = "ajax4jsf";
                    String className = "org.ajax4jsf.Filter";
                    util.configureFilter(project, monitor, filterName, className, displayName, description);
                    String servletName = util.findJsfServlet(provider.getModelObject());
                    if (servletName == null) {
                        RuntimeException e = new RuntimeException(Messages.JSFPortletFacetInstallDelegate_Cannot_find_the_JSF_servlet);
                        PortletCoreActivator.log(e);
                        throw e;
                    }
                    util.configureFilterMapping(project, monitor, filterName, servletName);
                } else {
                    String name = "javax.portlet.faces.renderPolicy";
                    String value = "NEVER_DELEGATE";
                    String description = null;
                    util.configureContextParam(project, monitor, name, value, description);
                }
            }
        }, modelPath);
    }

    private boolean addRichfacesLibraries(IProject project) {
        boolean isSeamFacet = false;
        try {
            isSeamFacet = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)JST_SEAM_FACET);
        }
        catch (CoreException e) {
            PortletCoreActivator.log(e);
        }
        if (isSeamFacet) {
            return true;
        }
        return this.richfacesCapabilities;
    }

    private void addLibrariesFromServerRuntime(IFacetedProject facetedProject) {
        boolean addRichfacesFromRichfacesRuntime;
        final boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
        boolean bl = addRichfacesFromRichfacesRuntime = this.richfacesCapabilities && IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richfacesType) && !this.isEPP;
        if (addRichfacesFromRichfacesRuntime) {
            this.addRichfacesFromRichfacesRuntime(facetedProject);
        }
        if (isSeamProject) {
            return;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetedProject.getPrimaryRuntime();
        if (facetRuntime == null) {
            return;
        }
        IRuntime runtime = PortletCoreActivator.getRuntime(facetRuntime);
        if (runtime == null) {
            return;
        }
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            File richfacesLib;
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            IPath portletLib = configPath.append("deploy/jboss-portal.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
            File libFile = portletLib.toFile();
            if (!libFile.exists()) {
                portletLib = configPath.append("deploy/jboss-portal-ha.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
                libFile = portletLib.toFile();
            }
            if (!(richfacesLib = libFile).exists()) {
                PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_Richfaces_ibraries);
                return;
            }
            if (!richfacesLib.isDirectory()) {
                PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_Richfaces_ibraries);
                return;
            }
            try {
                IProject project = facetedProject.getProject();
                final IProject earProject = this.getEarProject(project, isSeamProject);
                String[] fileList = richfacesLib.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (!addRichfacesFromRichfacesRuntime) {
                            if (name.startsWith("richfaces-ui") && name.endsWith(PortletPostInstallListener.JAR)) {
                                return true;
                            }
                            if (name.startsWith("richfaces-impl") && name.endsWith(PortletPostInstallListener.JAR)) {
                                return true;
                            }
                            if (earProject == null && name.startsWith("richfaces-api") && name.endsWith(PortletPostInstallListener.JAR)) {
                                return true;
                            }
                        }
                        if (!isSeamProject) {
                            if (name.startsWith("portal")) {
                                return false;
                            }
                            return !name.startsWith("portletbridge");
                        }
                        return false;
                    }
                });
                ArrayList<File> filesToImport = new ArrayList<File>();
                int i = 0;
                while (i < fileList.length) {
                    filesToImport.add(new File(richfacesLib, fileList[i]));
                    ++i;
                }
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFolder rootFolder = component.getRootFolder();
                IContainer folder = rootFolder.getUnderlyingFolder();
                IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
                this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
                ImportOperation importOperation = new ImportOperation(webinf.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                importOperation.setCreateContainerStructure(false);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                if (earProject != null) {
                    fileList = richfacesLib.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith("richfaces-api") && name.endsWith(PortletPostInstallListener.JAR);
                        }
                    });
                    filesToImport = new ArrayList();
                    int i2 = 0;
                    while (i2 < fileList.length) {
                        filesToImport.add(new File(richfacesLib, fileList[i2]));
                        ++i2;
                    }
                    component = ComponentCore.createComponent((IProject)earProject);
                    rootFolder = component.getRootFolder();
                    folder = rootFolder.getUnderlyingFolder();
                    this.deleteOldRichFacesApi(folder);
                    importOperation = new ImportOperation(folder.getFullPath(), (Object)richfacesLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                    importOperation.setCreateContainerStructure(false);
                    importOperation.run((IProgressMonitor)new NullProgressMonitor());
                    this.updateEARLibraries(project, isSeamProject);
                }
            }
            catch (Exception e) {
                PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
            }
        }
    }

    private void addRichfacesFromRichfacesRuntime(IFacetedProject facetedProject) {
        boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
        if (!isSeamProject && !this.richfacesCapabilities) {
            return;
        }
        File richfacesRuntimeHome = new File(this.richfacesRuntime);
        File richfacesLib = new File(richfacesRuntimeHome, "lib");
        if (!richfacesLib.isDirectory()) {
            File artifacts = new File(richfacesRuntimeHome, "artifacts");
            File ui = new File(artifacts, "ui");
            File framework = new File(artifacts, "framework");
            if (!ui.isDirectory() || !framework.isDirectory()) {
                PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Invalid_Richfaces_Runtime);
                return;
            }
            this.addRichfaces4(facetedProject, isSeamProject, ui, framework);
            return;
        }
        this.addRichfaces3(facetedProject, isSeamProject, richfacesLib);
    }

    private void addRichfaces4(IFacetedProject facetedProject, boolean isSeamProject, File ui, File framework) {
        try {
            IProject project = facetedProject.getProject();
            IProject earProject = this.getEarProject(project, isSeamProject);
            String[] fileList = framework.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("richfaces-core") && name.endsWith(PortletPostInstallListener.JAR) && !name.endsWith(PortletPostInstallListener.SOURCES_JAR);
                }
            });
            ArrayList<File> filesToImport = new ArrayList<File>();
            int i = 0;
            while (i < fileList.length) {
                filesToImport.add(new File(framework, fileList[i]));
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
            this.importFiles(project, earProject, filesToImport, framework, (IContainer)webinf, isSeamProject);
            fileList = ui.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("richfaces-components") && name.endsWith(PortletPostInstallListener.JAR) && !name.endsWith(PortletPostInstallListener.SOURCES_JAR);
                }
            });
            int i2 = 0;
            while (i2 < fileList.length) {
                filesToImport.add(new File(ui, fileList[i2]));
                ++i2;
            }
            this.importFiles(project, earProject, filesToImport, ui, (IContainer)webinf, isSeamProject);
        }
        catch (Exception e) {
            PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
        }
    }

    private void importFiles(IProject project, IProject earProject, List<File> filesToImport, File sourceDir, IContainer webinf, boolean isSeamProject) throws InvocationTargetException, InterruptedException, CoreException {
        ImportOperation importOperation = new ImportOperation(webinf.getFullPath(), (Object)sourceDir, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
        importOperation.setCreateContainerStructure(false);
        importOperation.run((IProgressMonitor)new NullProgressMonitor());
        if (earProject != null) {
            String[] fileList = sourceDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.startsWith("richfaces-core-api") && name.endsWith(PortletPostInstallListener.JAR) && !name.endsWith(PortletPostInstallListener.SOURCES_JAR)) {
                        return true;
                    }
                    if (name.startsWith("richfaces-components-api") && name.endsWith(PortletPostInstallListener.JAR) && !name.endsWith(PortletPostInstallListener.SOURCES_JAR)) {
                        return true;
                    }
                    return name.startsWith("richfaces-api") && name.endsWith(PortletPostInstallListener.JAR) && !name.endsWith(PortletPostInstallListener.SOURCES_JAR);
                }
            });
            filesToImport = new ArrayList<File>();
            int i = 0;
            while (i < fileList.length) {
                filesToImport.add(new File(sourceDir, fileList[i]));
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            this.deleteOldRichFacesApi(folder);
            importOperation = new ImportOperation(folder.getFullPath(), (Object)sourceDir, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            importOperation.run((IProgressMonitor)new NullProgressMonitor());
            this.updateEARLibraries(project, isSeamProject);
        }
    }

    private void addRichfaces3(IFacetedProject facetedProject, boolean isSeamProject, File richfacesLib) {
        try {
            IProject project = facetedProject.getProject();
            final IProject earProject = this.getEarProject(project, isSeamProject);
            String[] fileList = richfacesLib.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.startsWith("richfaces-ui") && name.endsWith(PortletPostInstallListener.JAR)) {
                        return true;
                    }
                    if (name.startsWith("richfaces-impl") && name.endsWith(PortletPostInstallListener.JAR)) {
                        return true;
                    }
                    return earProject == null && name.startsWith("richfaces-api") && name.endsWith(PortletPostInstallListener.JAR);
                }
            });
            ArrayList<File> filesToImport = new ArrayList<File>();
            int i = 0;
            while (i < fileList.length) {
                filesToImport.add(new File(richfacesLib, fileList[i]));
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
            this.importFiles(project, earProject, filesToImport, richfacesLib, (IContainer)webinf, isSeamProject);
        }
        catch (Exception e) {
            PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
        }
    }

    private void updateEARLibraries(IProject project, boolean isSeamProject) {
        IProject ejbProj = this.getEjbProject(project, isSeamProject);
        IProject earProject = this.getEarProject(project, isSeamProject);
        IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer folder = rootFolder.getUnderlyingFolder();
        File earContentFolder = folder.getLocation().toFile();
        File[] earJars = earContentFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.lastIndexOf(PortletPostInstallListener.JAR) > 0;
            }
        });
        String clientURI = "";
        File[] fileArray = earJars;
        int n = earJars.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            clientURI = String.valueOf(clientURI) + " " + file.getName();
            ++n2;
        }
        try {
            new UpdateManifestOperation(ejbProj, clientURI, true).run();
            new UpdateManifestOperation(project, clientURI, true).run();
        }
        catch (Exception e) {
            PortletCoreActivator.log(e);
        }
    }

    private void addLibrariesFromPortletBridgeRuntime(IFacetedProject facetedProject, String portletbridgeRuntime, boolean addRichfaces) {
        File portletbridgeHome = this.isEPP ? PortletCoreActivator.getEPPDir((IFacetedProjectBase)facetedProject, "portletbridge") : new File(portletbridgeRuntime);
        if (portletbridgeHome == null || !portletbridgeHome.exists()) {
            PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_Portletbridge_Runtime);
            return;
        }
        if (!portletbridgeHome.isDirectory()) {
            PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Invalid_Portletbridge_Runtime);
            return;
        }
        if (this.isEPP) {
            this.getLibrariesFromEPP(facetedProject);
        } else {
            this.getLibrariesFromExamples(facetedProject, portletbridgeHome);
        }
    }

    private void getLibrariesFromEPP(IFacetedProject facetedProject) {
        File seamHome = PortletCoreActivator.getEPPDir((IFacetedProjectBase)facetedProject, "seam");
        File seamLib = new File(seamHome, "lib");
        if (seamLib == null || !seamLib.isDirectory()) {
            PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_the_seam_lib_directory);
            return;
        }
        try {
            ImportOperation op;
            boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
            IProject project = facetedProject.getProject();
            List<File> filesToImport = this.prepareList(seamLib, facetedProject, isSeamProject);
            if (filesToImport != null) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFolder rootFolder = component.getRootFolder();
                IContainer folder = rootFolder.getUnderlyingFolder();
                IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
                op = new ImportOperation(webinf.getFullPath(), (Object)seamLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_NONE_QUERY, filesToImport);
                op.setCreateContainerStructure(false);
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            IProject earProject = this.getEarProject(project, isSeamProject);
            filesToImport = this.prepareEarList(seamLib);
            if (earProject != null && filesToImport != null) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
                IVirtualFolder rootFolder = component.getRootFolder();
                IContainer folder = rootFolder.getUnderlyingFolder();
                this.deleteOldRichFacesApi(folder);
                op = new ImportOperation(folder.getFullPath(), (Object)seamLib, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_NONE_QUERY, filesToImport);
                op.setCreateContainerStructure(false);
                op.run((IProgressMonitor)new NullProgressMonitor());
                this.updateEARLibraries(project, isSeamProject);
            }
        }
        catch (Exception e) {
            PortletCoreActivator.log(e);
        }
    }

    private List<File> prepareEarList(File seamLib) {
        File[] files = seamLib.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.endsWith(PortletPostInstallListener.JAR) && name.startsWith("richfaces-api");
            }
        });
        if (files == null) {
            return null;
        }
        return Arrays.asList(files);
    }

    private List<File> prepareList(File directory, IFacetedProject facetedProject, final boolean isSeamProject) {
        final IProject earProject = this.getEarProject(facetedProject.getProject(), isSeamProject);
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                if (name == null) {
                    return false;
                }
                if (!name.endsWith(PortletPostInstallListener.JAR)) {
                    return false;
                }
                if (name.startsWith("jsf-facelets")) {
                    return true;
                }
                if (PortletPostInstallListener.this.richfacesCapabilities) {
                    if (name.startsWith("richfaces-ui")) {
                        return true;
                    }
                    if (name.startsWith("richfaces-impl")) {
                        return true;
                    }
                    if (name.startsWith("richfaces-core-impl")) {
                        return true;
                    }
                    if (name.startsWith("richfaces-components-ui")) {
                        return true;
                    }
                    if (earProject == null) {
                        if (name.startsWith("richfaces-api")) {
                            return true;
                        }
                        if (name.startsWith("richfaces-core-api")) {
                            return true;
                        }
                        if (name.startsWith("richfaces-components-api")) {
                            return true;
                        }
                    }
                }
                if (!isSeamProject) {
                    if (name.startsWith("commons-beanutils")) {
                        return true;
                    }
                    if (name.startsWith("commons-digester")) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (files == null) {
            return null;
        }
        return Arrays.asList(files);
    }

    private void getLibrariesFromExamples(IFacetedProject facetedProject, File portletbridgeHome) {
        File examplesHome = new File(portletbridgeHome, "examples");
        if (!examplesHome.exists() || !examplesHome.isDirectory()) {
            PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_the_examples_directory);
            return;
        }
        File richFacesPortletZip = this.getRichFacesExamples(examplesHome);
        if (!richFacesPortletZip.exists() || !richFacesPortletZip.isFile()) {
            PortletCoreActivator.logMessage(Messages.PortletPostInstallListener_Cannot_find_the_RichFacesPortlet_war_file);
            return;
        }
        try {
            boolean addRichfacesFromRichfacesRuntime;
            ZipFile zipFile = new ZipFile(richFacesPortletZip);
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
            boolean isSeamProject = facetedProject.hasProjectFacet(seamFacet);
            boolean bl = addRichfacesFromRichfacesRuntime = this.richfacesCapabilities && IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richfacesType);
            if (addRichfacesFromRichfacesRuntime) {
                this.addRichfacesFromRichfacesRuntime(facetedProject);
            }
            List<ZipEntry> list = this.prepareList(zipFile, facetedProject, isSeamProject, addRichfacesFromRichfacesRuntime);
            IProject project = facetedProject.getProject();
            IProject earProject = this.getEarProject(project, isSeamProject);
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            if (!addRichfacesFromRichfacesRuntime) {
                this.deleteOldRichfacesLibs(earProject, (IContainer)webinf);
            }
            IPath destPath = folder.getFullPath();
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, OVERWRITE_NONE_QUERY, list);
            op.run((IProgressMonitor)new NullProgressMonitor());
            if (earProject != null) {
                list = this.prepareEarList(zipFile);
                component = ComponentCore.createComponent((IProject)earProject);
                rootFolder = component.getRootFolder();
                folder = rootFolder.getUnderlyingFolder();
                this.deleteOldRichFacesApi(folder);
                destPath = folder.getFullPath();
                ZipEntry root = zipFile.getEntry("WEB-INF/lib");
                if (root == null) {
                    root = zipFile.getEntry("lib");
                }
                op = new ImportOperation(destPath, (Object)root, (IImportStructureProvider)structureProvider, OVERWRITE_NONE_QUERY, list);
                op.setCreateContainerStructure(false);
                op.run((IProgressMonitor)new NullProgressMonitor());
                this.updateEARLibraries(project, isSeamProject);
            }
        }
        catch (Exception e) {
            PortletCoreActivator.log(e);
        }
    }

    private File getRichFacesExamples(File examplesHome) {
        File file = this.getExampleFile(examplesHome, "RichFacesPortlet", "war");
        if (file != null && file.isFile()) {
            return file;
        }
        file = this.getExampleFile(examplesHome, "richFacesPortlet", ".war");
        if (file != null && file.isFile()) {
            return file;
        }
        file = this.getExampleFile(examplesHome, "seamPortlet", ".war");
        if (file != null && file.isFile()) {
            return file;
        }
        file = this.getExampleFile(examplesHome, "seam", ".ear");
        if (file != null && file.isFile()) {
            return file;
        }
        return null;
    }

    private File getExampleFile(File examplesHome, final String prefix, final String suffix) {
        File[] listFiles = examplesHome.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(suffix);
            }
        });
        if (listFiles.length > 0) {
            return listFiles[0];
        }
        return null;
    }

    private void deleteOldRichFacesApi(IContainer folder) throws CoreException {
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource != null && resource.exists()) {
                if (resource.getName().startsWith("richfaces-api") && resource.getName().endsWith("jar")) {
                    resource.delete(true, null);
                }
                if (resource.getName().startsWith("richfaces-core-api") && resource.getName().endsWith("jar")) {
                    resource.delete(true, null);
                }
                if (resource.getName().startsWith("richfaces-components-api") && resource.getName().endsWith("jar")) {
                    resource.delete(true, null);
                }
            }
            ++i;
        }
    }

    private void deleteOldRichfacesLibs(IProject earProject, IContainer webinf) throws CoreException {
        if (webinf != null && webinf.exists()) {
            IResource[] members = webinf.members();
            int i = 0;
            while (i < members.length) {
                IResource resource = members[i];
                if (resource != null && resource.exists()) {
                    if (resource.getName().startsWith("richfaces-ui") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (resource.getName().startsWith("richfaces-core") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (resource.getName().startsWith("richfaces-components") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (resource.getName().startsWith("richfaces-impl") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                    if (earProject == null && resource.getName().startsWith("richfaces-api") && resource.getName().endsWith("jar")) {
                        resource.delete(true, null);
                    }
                }
                ++i;
            }
        }
    }

    private IProject getEarProject(IProject project, boolean isSeamProject) {
        if (isSeamProject && project != null) {
            IEclipsePreferences preferences = PortletPostInstallListener.getSeamPreferences(project);
            String earProjectName = preferences.get("seam.ear.project", null);
            if (earProjectName == null) {
                return null;
            }
            IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName);
            if (earProject != null && earProject.isOpen()) {
                return earProject;
            }
        }
        return null;
    }

    private IProject getEjbProject(IProject project, boolean isSeamProject) {
        if (isSeamProject && project != null) {
            IEclipsePreferences preferences = PortletPostInstallListener.getSeamPreferences(project);
            String ejbProjectName = preferences.get("seam.ejb.project", null);
            if (ejbProjectName == null) {
                return null;
            }
            IProject ejbProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ejbProjectName);
            if (ejbProject != null && ejbProject.isOpen()) {
                return ejbProject;
            }
        }
        return null;
    }

    public static IEclipsePreferences getSeamPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode("org.jboss.tools.seam.core");
    }

    private List<ZipEntry> prepareList(ZipFile rootEntry, IFacetedProject facetedProject, boolean isSeamProject, boolean addRichfacesFromRichfacesRuntime) {
        if (rootEntry == null) {
            return null;
        }
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
        if (!isSeamProject && !this.richfacesCapabilities) {
            return list;
        }
        Enumeration<? extends ZipEntry> entries = rootEntry.entries();
        IProject earProject = this.getEarProject(facetedProject.getProject(), isSeamProject);
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(JAR)) continue;
            if (!addRichfacesFromRichfacesRuntime) {
                if (entry.getName().startsWith("WEB-INF/lib/richfaces-ui")) {
                    list.add(entry);
                }
                if (entry.getName().startsWith("WEB-INF/lib/richfaces-impl")) {
                    list.add(entry);
                }
                if (earProject == null && entry.getName().startsWith("WEB-INF/lib/richfaces-api")) {
                    list.add(entry);
                }
            }
            if (isSeamProject || !entry.getName().startsWith("WEB-INF/lib/commons-beanutils") && !entry.getName().startsWith("WEB-INF/lib/commons-digester") && !entry.getName().startsWith("WEB-INF/lib/jsf-facelets")) continue;
            list.add(entry);
        }
        return list;
    }

    private List<ZipEntry> prepareEarList(ZipFile zipFile) {
        if (zipFile == null) {
            return null;
        }
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(JAR) || !entry.getName().startsWith("WEB-INF/lib/richfaces-api")) continue;
            list.add(entry);
        }
        return list;
    }

    private class UpdateManifestOperation
    implements Runnable {
        protected IProject project;
        protected String classPathValue;
        protected boolean replace;

        public UpdateManifestOperation(IProject project, String aSpaceDelimitedPath, boolean replaceInsteadOfMerge) {
            this.project = project;
            this.classPathValue = aSpaceDelimitedPath;
            this.replace = replaceInsteadOfMerge;
        }

        public void run() {
            ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)this.project);
            if (mf == null) {
                mf = new ArchiveManifestImpl();
            }
            mf.addVersionIfNecessary();
            if (this.replace) {
                mf.setClassPath(this.classPathValue);
            } else {
                mf.mergeClassPath(ArchiveUtil.getTokens((String)this.classPathValue));
            }
            try {
                J2EEProjectUtilities.writeManifest((IProject)this.project, (ArchiveManifest)mf);
            }
            catch (IOException e) {
                PortletCoreActivator.log(e);
            }
        }
    }
}

